/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;

public class SerializerVec3d
implements ISerializer<Vector3d> {
    public static final ISerializer<Vector3d> SERIALIZER = new SerializerVec3d();

    @Override
    public Vector3d read(JsonElement json) {
        List<Double> values = Serializers.DOUBLE.readList(json);
        if (values.size() == 3) {
            return new Vector3d(values.get(0).doubleValue(), values.get(1).doubleValue(), values.get(2).doubleValue());
        }
        throw new JsonParseException("Expected 3 elements, had " + values.size() + " instead.");
    }

    @Override
    public JsonElement write(Vector3d toWrite) {
        return Serializers.DOUBLE.writeList(new ArrayList<Double>(Arrays.asList(toWrite.field_72450_a, toWrite.field_72448_b, toWrite.field_72449_c)));
    }

    @Override
    public Vector3d read(PacketBuffer buffer) {
        List<Double> values = Serializers.DOUBLE.readList(buffer);
        if (values.size() == 3) {
            return new Vector3d(values.get(0).doubleValue(), values.get(1).doubleValue(), values.get(2).doubleValue());
        }
        throw new IllegalStateException("Expected 3 elements, had " + values.size() + " instead.");
    }

    @Override
    public void write(PacketBuffer buffer, Vector3d toWrite) {
        Serializers.DOUBLE.writeList(buffer, new ArrayList<Double>(Arrays.asList(toWrite.field_72450_a, toWrite.field_72448_b, toWrite.field_72449_c)));
    }

    @Override
    public INBT writeNBT(Vector3d toWrite) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a("x", toWrite.func_82615_a());
        tag.func_74780_a("y", toWrite.func_82617_b());
        tag.func_74780_a("z", toWrite.func_82616_c());
        return tag;
    }

    @Override
    public Vector3d read(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            CompoundNBT tag = (CompoundNBT)nbt;
            double x = tag.func_74769_h("x");
            double y = tag.func_74769_h("y");
            double z = tag.func_74769_h("z");
            return new Vector3d(x, y, z);
        }
        throw new IllegalArgumentException("Expected NBT to be a compound tag. Class was " + nbt.getClass() + " with ID " + nbt.func_74732_a() + " instead.");
    }
}

