/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonUtils {
    private static MinecraftServer server;

    static void initialize() {
        MinecraftForge.EVENT_BUS.addListener(e -> {
            server = e.getServer();
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            server = null;
        });
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static World getLevel(RegistryKey<World> resourceKey) {
        MinecraftServer server = CommonUtils.getServer();
        return server == null ? null : server.func_71218_a(resourceKey);
    }

    public static CoreSide getEnvironmentSide() {
        return CoreSide.fromUnderlying(FMLEnvironment.dist);
    }

    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static void openContainer(final BaseContainer container) {
        PlayerEntity player = container.player;
        if (!(container.player instanceof ServerPlayerEntity)) {
            return;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return TextComponents.empty().get();
            }

            @Nullable
            public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
                container.setContainerId(windowId);
                return container;
            }
        }, data -> container.getContainerType().writeContainer(container, (PacketBuffer)data));
    }

    public static void closeContainer(PlayerEntity player) {
        player.func_71053_j();
    }

    public static Logger getLogger(String modid) {
        return LogManager.getLogger((String)modid);
    }
}

