/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.TranslationsAggregator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class LanguageGenerator
extends ResourceGenerator {
    private final Map<String, String> translations = new LinkedHashMap<String, String>();
    protected final String langCode;

    public LanguageGenerator(String modid, ResourceCache cache, String langCode) {
        super(modid, cache);
        if (!langCode.matches("[a-z]{2}_[a-z]{2}")) {
            throw new IllegalArgumentException("Invalid lang code '" + langCode + "'!");
        }
        this.langCode = langCode;
    }

    @Override
    public void save() {
        this.cache.saveResource(ResourceType.ASSET, TranslationsAggregator.INSTANCE, this.translations, this.modid, "lang", this.langCode, ".json");
    }

    protected void translation(String translationKey, String translation) {
        if (translationKey.trim().isEmpty()) {
            throw new IllegalArgumentException("Translation key '" + translation + "' for translation '" + translation + "' must not be empty!");
        }
        this.translations.put(translationKey, translation);
    }

    protected void itemGroup(ItemGroup group, String translation) {
        ITextComponent component = group.func_242392_c();
        if (component instanceof TranslationTextComponent) {
            this.translation(((TranslationTextComponent)component).func_150268_i(), translation);
        }
        this.translation(group.field_78034_o, translation);
    }

    protected void item(Item item, String translation) {
        this.translation(item.func_77658_a(), translation);
    }

    protected void block(Block block, String translation) {
        this.translation(block.func_149739_a(), translation);
    }

    @Override
    public String getName() {
        return this.modName + " Language Generator";
    }
}

