/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class WidgetContainerScreen<T extends Widget, X extends BaseContainer>
extends ContainerScreen<X> {
    private static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("supermartijn642corelib", "textures/gui/slot.png");
    protected final X container;
    protected final T widget;
    private boolean initialized = false;
    private final boolean drawSlots;
    private final boolean isPauseScreen;

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots, isPauseScreen);
    }

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots);
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        super(container, ((BaseContainer)((Object)container)).player.field_71071_by, (ITextComponent)TextComponents.empty().get());
        this.widget = widget;
        this.container = container;
        this.drawSlots = drawSlots;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots) {
        this(widget, container, drawSlots, false);
    }

    public void func_231160_c_() {
        if (!this.initialized) {
            if (this.widget instanceof ContainerWidget) {
                ((ContainerWidget)this.widget).initialize(this.container);
            } else {
                this.widget.initialize();
            }
            this.initialized = true;
        }
        this.field_146999_f = this.widget.width();
        this.field_147000_g = this.widget.height();
        super.func_231160_c_();
    }

    public void func_231175_as__() {
        this.widget.discard();
        super.func_231175_as__();
    }

    public void func_231023_e_() {
        this.widget.update();
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        ItemStack cursorStack;
        this.func_230446_a_(poseStack);
        int offsetX = (this.field_230708_k_ - this.widget.width()) / 2;
        int offsetY = (this.field_230709_l_ - this.widget.height()) / 2;
        int offsetMouseX = mouseX - offsetX;
        int offsetMouseY = mouseY - offsetY;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)offsetX, (float)offsetY, (float)0.0f);
        RenderSystem.disableDepthTest();
        this.widget.setFocused(offsetMouseX >= 0 && offsetMouseX < this.widget.width() && offsetMouseY >= 0 && offsetMouseY < this.widget.height());
        this.widget.renderBackground(poseStack, offsetMouseX, offsetMouseY);
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.container)).field_75151_b) {
                ScreenUtils.bindTexture(SLOT_TEXTURE);
                ScreenUtils.drawTexture(poseStack, slot.field_75223_e - 1, slot.field_75221_f - 1, 18.0f, 18.0f);
            }
        }
        RenderSystem.popMatrix();
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawBackground((ContainerScreen)this, poseStack, mouseX, mouseY));
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)offsetX, (float)offsetY, (float)0.0f);
        this.widget.render(poseStack, offsetMouseX, offsetMouseY);
        this.field_147006_u = null;
        for (Slot slot : ((BaseContainer)((Object)this.container)).field_75151_b) {
            if (!slot.func_111238_b()) continue;
            this.func_238746_a_(poseStack, slot);
            if (!this.func_195359_a(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            this.field_147006_u = slot;
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int slotColor = this.getSlotColor(0);
            this.func_238468_a_(poseStack, slot.field_75223_e, slot.field_75221_f, slot.field_75223_e + 16, slot.field_75221_f + 16, slotColor, slotColor);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
        this.widget.renderForeground(poseStack, offsetMouseX, offsetMouseY);
        this.func_230459_a_(poseStack, offsetMouseX, offsetMouseY);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground((ContainerScreen)this, poseStack, mouseX, mouseY));
        ItemStack itemStack = cursorStack = this.field_147012_x.func_190926_b() ? this.field_213127_e.func_70445_o() : this.field_147012_x;
        if (!cursorStack.func_190926_b()) {
            int offset = this.field_147012_x.func_190926_b() ? 8 : 16;
            String s = null;
            if (!this.field_147012_x.func_190926_b() && this.field_147004_w) {
                cursorStack = cursorStack.func_77946_l();
                cursorStack.func_190920_e(MathHelper.func_76123_f((float)((float)cursorStack.func_190916_E() / 2.0f)));
            } else if (this.field_147007_t && this.field_147008_s.size() > 1) {
                cursorStack = cursorStack.func_77946_l();
                cursorStack.func_190920_e(this.field_146996_I);
                if (cursorStack.func_190926_b()) {
                    s = TextFormatting.YELLOW + "0";
                }
            }
            this.func_146982_a(cursorStack, offsetMouseX - 8, offsetMouseY - offset, s);
        }
        if (!this.field_146991_C.func_190926_b()) {
            float f = (float)(Util.func_211177_b() - this.field_146990_B) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.field_146991_C = ItemStack.field_190927_a;
            }
            int j2 = this.field_146989_A.field_75223_e - this.field_147011_y;
            int k2 = this.field_146989_A.field_75221_f - this.field_147010_z;
            int j1 = this.field_147011_y + (int)((float)j2 * f);
            int k1 = this.field_147010_z + (int)((float)k2 * f);
            this.func_146982_a(this.field_146991_C, j1, k1, null);
        }
        this.widget.renderOverlay(poseStack, offsetMouseX, offsetMouseY);
        this.widget.renderTooltips(poseStack, offsetMouseX, offsetMouseY);
        RenderSystem.popMatrix();
        RenderSystem.enableDepthTest();
    }

    protected void func_230450_a_(MatrixStack poseStack, float partialTicks, int mouseX, int mouseY) {
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.field_230708_k_ - this.widget.width()) / 2;
        return this.widget.mousePressed((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.field_230709_l_ - this.widget.height()) / 2), button, false) || super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.field_230708_k_ - this.widget.width()) / 2;
        return this.widget.mouseReleased((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.field_230709_l_ - this.widget.height()) / 2), button, false) || super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        int offsetY;
        int offsetX = (this.field_230708_k_ - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.field_230709_l_ - this.widget.height()) / 2), amount, false) || super.func_231043_a_(mouseX, mouseY, amount);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        InputMappings.Input key = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(key)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return this.widget.keyReleased(keyCode, false) || super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char character, int modifiers) {
        return this.widget.charTyped(character, false) || super.func_231042_a_(character, modifiers);
    }

    public boolean func_231177_au__() {
        return this.isPauseScreen;
    }

    public String func_231167_h_() {
        ITextComponent message = this.widget.getNarrationMessage();
        return message == null ? "" : TextComponents.fromTextComponent(message).format();
    }
}

