/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget.premade;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;

public class TextFieldWidget
extends BaseWidget {
    private String text;
    private String suggestion = "";
    protected int maxLength;
    private int cursorBlinkCounter;
    protected boolean selected;
    private boolean active = true;
    protected int lineScrollOffset;
    protected int cursorPosition;
    protected int selectionPos;
    protected boolean drawBackground = true;
    protected int activeTextColor = 0xE0E0E0;
    protected int inactiveTextColor = 0x707070;
    private final BiConsumer<String, String> changeListener;

    public TextFieldWidget(int x, int y, int width, int height, String defaultText, int maxLength, BiConsumer<String, String> changeListener) {
        super(x, y, width, height);
        this.text = defaultText;
        this.maxLength = maxLength;
        this.changeListener = changeListener;
        this.cursorPosition = this.selectionPos = defaultText.length();
    }

    public TextFieldWidget(int x, int y, int width, int height, String defaultText, int maxLength, Consumer<String> changeListener) {
        this(x, y, width, height, defaultText, maxLength, changeListener == null ? null : (a, b) -> changeListener.accept((String)b));
    }

    public TextFieldWidget(int x, int y, int width, int height, String defaultText, int maxLength) {
        this(x, y, width, height, defaultText, maxLength, (BiConsumer<String, String>)null);
    }

    @Override
    public ITextComponent getNarrationMessage() {
        return TextComponents.translation("gui.narrate.editBox", this.suggestion, this.text).get();
    }

    @Override
    public void update() {
        ++this.cursorBlinkCounter;
    }

    @Override
    public void render(MatrixStack poseStack, int mouseX, int mouseY) {
        if (this.drawBackground) {
            this.drawBackground(poseStack);
        }
        int textColor = this.active ? this.activeTextColor : this.inactiveTextColor;
        int relativeCursor = this.cursorPosition - this.lineScrollOffset;
        int relativeSelection = this.selectionPos - this.lineScrollOffset;
        FontRenderer fontRenderer = ClientUtils.getFontRenderer();
        String s = fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), this.width - 8);
        boolean cursorInView = relativeCursor >= 0 && relativeCursor <= s.length();
        boolean shouldBlink = this.selected && this.cursorBlinkCounter / 8 % 2 == 0 && cursorInView;
        int left = this.x + 4;
        int top = this.y + (this.height - 8) / 2;
        int leftOffset = left;
        if (relativeSelection > s.length()) {
            relativeSelection = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = cursorInView ? s.substring(0, relativeCursor) : s;
            leftOffset = fontRenderer.func_238421_b_(poseStack, s1, (float)left, (float)top, textColor) + 1;
        }
        boolean cursorAtEnd = this.cursorPosition < this.text.length();
        int cursorX = leftOffset;
        if (!cursorInView) {
            cursorX = relativeCursor > 0 ? left + this.width : left;
        } else if (cursorAtEnd) {
            cursorX = leftOffset - 1;
            --leftOffset;
        }
        if (!s.isEmpty() && cursorInView && relativeCursor < s.length()) {
            fontRenderer.func_238421_b_(poseStack, s.substring(relativeCursor), (float)leftOffset, (float)top, textColor);
        }
        if (!this.suggestion.isEmpty() && this.text.isEmpty()) {
            fontRenderer.func_238405_a_(poseStack, fontRenderer.func_238412_a_(this.suggestion, this.width - 8 - fontRenderer.func_78256_a("...")) + "...", (float)cursorX, (float)top, -8355712);
        }
        if (shouldBlink) {
            if (cursorAtEnd) {
                float f = (float)cursorX - 0.5f;
                float f2 = top - 1;
                fontRenderer.getClass();
                ScreenUtils.fillRect(poseStack, f, f2, 1.0f, 9.0f, -3092272);
            } else {
                fontRenderer.func_238405_a_(poseStack, "_", (float)cursorX, (float)top, textColor);
            }
        }
        if (relativeSelection != relativeCursor) {
            int l1 = left + fontRenderer.func_78256_a(s.substring(0, relativeSelection));
            fontRenderer.getClass();
            this.drawSelectionBox(poseStack, cursorX, top - 1, l1 - 1, top + 1 + 9);
        }
    }

    protected void drawBackground(MatrixStack poseStack) {
        ScreenUtils.fillRect(poseStack, this.x, this.y, this.width, this.height, this.selected ? -1 : -6250336);
        ScreenUtils.fillRect(poseStack, this.x + 1, this.y + 1, this.width - 2, this.height - 2, -16777216);
    }

    protected void drawSelectionBox(MatrixStack poseStack, int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Matrix4f matrix = poseStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_227888_a_(matrix, (float)startX, (float)endY, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)endX, (float)endY, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)endX, (float)startY, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)startX, (float)startY, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void clear() {
        this.setText("");
    }

    public void setText(String text) {
        String oldText = this.text;
        this.setTextSuppressed(text);
        if (!oldText.equals(this.text)) {
            this.onTextChanged(oldText, text);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setTextSuppressed(String text) {
        if (text == null) {
            text = "";
        } else if (text.length() > this.maxLength) {
            text = SharedConstants.func_71565_a((String)text.substring(0, this.maxLength));
        }
        this.lineScrollOffset = 0;
        this.cursorPosition = 0;
        this.selectionPos = 0;
        this.text = text;
    }

    protected void addTextAtCursor(String text) {
        String oldText = this.text;
        if ((text = SharedConstants.func_71565_a((String)text)).length() + this.text.length() - this.getSelectedText().length() > this.maxLength) {
            text = text.substring(0, this.maxLength - this.text.length() + this.getSelectedText().length() + 1);
        }
        int min = Math.min(this.cursorPosition, this.selectionPos);
        int max = Math.max(this.cursorPosition, this.selectionPos);
        this.text = this.text.substring(0, min) + text + this.text.substring(max);
        this.selectionPos = this.cursorPosition = min + text.length();
        this.moveLineOffsetToCursor();
        if (!oldText.equals(this.text)) {
            this.cursorBlinkCounter = 1;
            this.onTextChanged(oldText, this.text);
        }
    }

    protected void removeAtCursor(boolean left) {
        if (this.text.isEmpty()) {
            return;
        }
        String oldText = this.text;
        if (this.cursorPosition != this.selectionPos) {
            this.text = this.text.substring(0, Math.min(this.cursorPosition, this.selectionPos)) + this.text.substring(Math.max(this.cursorPosition, this.selectionPos));
            this.cursorPosition = this.selectionPos = Math.min(this.cursorPosition, this.selectionPos);
        } else if (left && this.cursorPosition > 0) {
            this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
            --this.cursorPosition;
            --this.selectionPos;
        } else if (!left && this.cursorPosition < this.text.length()) {
            this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
        }
        this.moveLineOffsetToCursor();
        this.cursorBlinkCounter = 1;
        this.onTextChanged(oldText, this.text);
    }

    protected void moveLineOffsetToCursor() {
        FontRenderer fontRenderer = ClientUtils.getFontRenderer();
        int availableWidth = this.width - 8 - (this.cursorPosition == this.text.length() ? fontRenderer.func_78256_a("_") : 0);
        int min = Math.min(this.cursorPosition + 1, this.text.length()) - fontRenderer.func_238412_a_(new StringBuilder(this.text.substring(0, Math.min(this.text.length(), this.cursorPosition + 2))).reverse().toString(), availableWidth).length();
        int max = Math.max(this.cursorPosition - 1, 0) + fontRenderer.func_238412_a_(this.text.substring(Math.max(this.cursorPosition - 1, 0)), availableWidth).length();
        max -= fontRenderer.func_238412_a_(new StringBuilder(this.text.substring(0, max)).reverse().toString(), availableWidth).length();
        this.lineScrollOffset = Math.min(Math.max(this.lineScrollOffset, min), max);
    }

    public String getSelectedText() {
        if (this.cursorPosition == this.selectionPos) {
            return "";
        }
        return this.text.substring(Math.min(this.cursorPosition, this.selectionPos), Math.max(this.cursorPosition, this.selectionPos));
    }

    protected void onTextChanged(String oldText, String newText) {
        if (this.changeListener != null) {
            this.changeListener.accept(oldText, newText);
        }
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion == null ? "" : suggestion;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setTextColors(int activeTextColor, int inactiveTextColor) {
        this.activeTextColor = activeTextColor;
        this.inactiveTextColor = inactiveTextColor;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            this.setSelected(false);
        }
    }

    @Override
    public boolean keyPressed(int keyCode, boolean hasBeenHandled) {
        if (hasBeenHandled || !this.canWrite() || !this.selected) {
            return false;
        }
        boolean shift = Screen.func_231173_s_();
        if (keyCode == 256) {
            this.setSelected(false);
        } else if (Screen.func_231170_j_((int)keyCode)) {
            this.lineScrollOffset = 0;
            this.cursorPosition = this.text.length();
            this.selectionPos = 0;
        } else if (Screen.func_231169_i_((int)keyCode)) {
            ClientUtils.getMinecraft().field_195559_v.func_197960_a(this.getSelectedText());
        } else if (Screen.func_231168_h_((int)keyCode)) {
            this.addTextAtCursor(ClientUtils.getMinecraft().field_195559_v.func_197965_a());
        } else if (Screen.func_231166_g_((int)keyCode)) {
            ClientUtils.getMinecraft().field_195559_v.func_197960_a(this.getSelectedText());
            this.addTextAtCursor("");
        } else {
            switch (keyCode) {
                case 259: {
                    this.removeAtCursor(true);
                    break;
                }
                default: {
                    return true;
                }
                case 261: {
                    this.removeAtCursor(false);
                    break;
                }
                case 262: {
                    if (!shift && this.cursorPosition != this.selectionPos) {
                        this.cursorPosition = this.selectionPos = Math.max(this.cursorPosition, this.selectionPos);
                    } else if (this.cursorPosition < this.text.length()) {
                        ++this.cursorPosition;
                        if (!shift) {
                            this.selectionPos = this.cursorPosition;
                        }
                    }
                    this.moveLineOffsetToCursor();
                    break;
                }
                case 263: {
                    if (!shift && this.cursorPosition != this.selectionPos) {
                        this.cursorPosition = this.selectionPos = Math.min(this.cursorPosition, this.selectionPos);
                    } else if (this.cursorPosition > 0) {
                        --this.cursorPosition;
                        if (!shift) {
                            this.selectionPos = this.cursorPosition;
                        }
                    }
                    this.moveLineOffsetToCursor();
                    break;
                }
                case 268: {
                    this.selectionPos = 0;
                    this.cursorPosition = 0;
                    this.moveLineOffsetToCursor();
                    break;
                }
                case 269: {
                    this.cursorPosition = this.selectionPos = this.text.length();
                    this.moveLineOffsetToCursor();
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean charTyped(char character, boolean hasBeenHandled) {
        if (hasBeenHandled || !this.canWrite()) {
            return false;
        }
        if (SharedConstants.func_71566_a((char)character)) {
            this.addTextAtCursor(Character.toString(character));
        }
        return true;
    }

    public boolean canWrite() {
        return this.active && this.selected;
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (!hasBeenHandled && this.active && this.isHovered(mouseX, mouseY)) {
            this.setSelected(true);
            if (button == 1) {
                this.clear();
            } else {
                int offset = MathHelper.func_76141_d((float)mouseX) - this.x - 4;
                FontRenderer font = ClientUtils.getFontRenderer();
                String s = font.func_238412_a_(this.text.substring(this.lineScrollOffset), Math.min(offset, this.width - 8));
                this.cursorPosition = s.length() + this.lineScrollOffset;
                if (!Screen.func_231173_s_()) {
                    this.selectionPos = this.cursorPosition;
                }
            }
            return true;
        }
        this.setSelected(false);
        return false;
    }

    private boolean isHovered(int mouseX, int mouseY) {
        return this.x <= mouseX && this.x + this.width > mouseX && this.y <= mouseY && this.y + this.height > mouseY;
    }
}

