/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.Registries;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BaseItem
extends Item {
    private final ItemProperties properties;

    public BaseItem(Item.Properties properties) {
        super(properties);
        this.properties = null;
    }

    public BaseItem(ItemProperties properties) {
        super(properties.toUnderlying());
        this.properties = properties;
    }

    protected void appendItemInformation(ItemStack stack, @Nullable IBlockReader level, Consumer<ITextComponent> info, boolean advanced) {
    }

    public ItemUseResult interact(ItemStack stack, PlayerEntity player, Hand hand, World level) {
        return ItemUseResult.fromUnderlying((ActionResult<ItemStack>)super.func_77659_a(level, player, hand));
    }

    public InteractionFeedback interactWithBlockFirst(ItemStack stack, PlayerEntity player, Hand hand, World level, BlockPos hitPos, Direction hitSide, Vector3d hitLocation) {
        return InteractionFeedback.PASS;
    }

    public InteractionFeedback interactWithBlock(ItemStack stack, PlayerEntity player, Hand hand, World level, BlockPos hitPos, Direction hitSide, Vector3d hitLocation) {
        return InteractionFeedback.PASS;
    }

    public InteractionFeedback interactWithEntity(ItemStack stack, LivingEntity target, PlayerEntity player, Hand hand) {
        return InteractionFeedback.PASS;
    }

    public void inventoryUpdate(ItemStack stack, World level, Entity entity, int itemSlot, boolean isSelected) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> information, ITooltipFlag flag) {
        this.appendItemInformation(stack, (IBlockReader)level, information::add, flag.func_194127_a());
        super.func_77624_a(stack, level, information, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        return this.interact(player.func_184586_b(hand), player, hand, level).toUnderlying(level.field_72995_K);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        return this.interactWithEntity(stack, target, player, hand).interactionResult;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return this.interactWithBlock(context.func_195996_i(), context.func_195999_j(), context.func_221531_n(), context.func_195991_k(), context.func_195995_a(), context.func_196000_l(), context.func_221532_j()).interactionResult;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return this.interactWithBlockFirst(stack, context.func_195999_j(), context.func_221531_n(), context.func_195991_k(), context.func_195995_a(), context.func_196000_l(), context.func_221532_j()).interactionResult;
    }

    public void func_77663_a(ItemStack stack, World level, Entity entity, int slot, boolean isSelected) {
        this.inventoryUpdate(stack, level, entity, slot, isSelected);
    }

    protected String func_195935_o() {
        ResourceLocation identifier = Registries.ITEMS.getIdentifier(this);
        return identifier.func_110624_b() + ".item." + identifier.func_110623_a();
    }

    public boolean isInCreativeGroup(ItemGroup tab) {
        return this.properties != null && this.properties.groups.contains(tab);
    }

    public Collection<ItemGroup> getCreativeTabs() {
        return this.properties != null ? this.properties.groups : super.getCreativeTabs();
    }

    public static enum InteractionFeedback {
        PASS(ActionResultType.PASS),
        CONSUME(ActionResultType.CONSUME),
        SUCCESS(ActionResultType.SUCCESS);

        private final ActionResultType interactionResult;

        private InteractionFeedback(ActionResultType interactionResult) {
            this.interactionResult = interactionResult;
        }

        @Deprecated
        public ActionResultType getUnderlying() {
            return this.interactionResult;
        }
    }

    protected static class ItemUseResult {
        private final ActionResultType result;
        private final ItemStack resultingStack;

        public static ItemUseResult pass(ItemStack stack) {
            return new ItemUseResult(ActionResultType.SUCCESS, stack);
        }

        public static ItemUseResult consume(ItemStack stack) {
            return new ItemUseResult(ActionResultType.CONSUME, stack);
        }

        public static ItemUseResult success(ItemStack stack) {
            return new ItemUseResult(ActionResultType.SUCCESS, stack);
        }

        public static ItemUseResult fail(ItemStack stack) {
            return new ItemUseResult(ActionResultType.FAIL, stack);
        }

        @Deprecated
        public static ItemUseResult fromUnderlying(ActionResult<ItemStack> underlying) {
            return new ItemUseResult(underlying.func_188397_a(), (ItemStack)underlying.func_188398_b());
        }

        private ItemUseResult(ActionResultType result, ItemStack resultingStack) {
            this.result = result;
            this.resultingStack = resultingStack;
        }

        @Deprecated
        public ActionResult<ItemStack> toUnderlying(boolean isClientSide) {
            return new ActionResult(this.result == ActionResultType.SUCCESS ? (isClientSide ? ActionResultType.SUCCESS : ActionResultType.CONSUME) : this.result, (Object)this.resultingStack);
        }
    }
}

