/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.supermartijn642.core.block.BaseBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ForgeHooks.class})
public class ForgeHooksMixin {
    @Redirect(method={"canHarvestBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getHarvestLevel(Lnet/minecraftforge/common/ToolType;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/block/BlockState;)I"), remap=false)
    private static int canHarvestBlockRedirect(ItemStack stack, ToolType type, PlayerEntity player, BlockState state) {
        if (state.func_177230_c() instanceof BaseBlock) {
            int bestHarvestLevel = -1;
            for (ToolType toolType : stack.getToolTypes()) {
                int harvestLevel;
                if (!state.isToolEffective(toolType) || (harvestLevel = stack.getHarvestLevel(toolType, player, state)) <= bestHarvestLevel) continue;
                bestHarvestLevel = harvestLevel;
            }
            if (bestHarvestLevel == -1) {
                bestHarvestLevel = stack.getHarvestLevel(type, player, state);
            }
            return bestHarvestLevel;
        }
        return stack.getHarvestLevel(type, player, state);
    }
}

