/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.core.render.RenderStateConfiguration;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class RenderConfiguration
extends RenderType {
    public static RenderConfiguration create(String modid, String name, VertexFormat format, PrimitiveType primitive, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderStateConfiguration renderStateConfiguration) {
        return new RenderConfiguration(modid + ":" + name, format, primitive.getGlMode(), bufferSize, affectsCrumbling, sortOnUpload, renderStateConfiguration::setup, renderStateConfiguration::clear);
    }

    public static RenderConfiguration wrap(RenderType renderType) {
        if (renderType instanceof RenderConfiguration) {
            return (RenderConfiguration)renderType;
        }
        return new RenderConfiguration(renderType.toString(), renderType.func_228663_p_(), renderType.func_228664_q_(), renderType.func_228662_o_(), renderType.func_228665_s_(), renderType.field_228629_af_, () -> ((RenderType)renderType).func_228547_a_(), () -> ((RenderType)renderType).func_228549_b_());
    }

    private RenderConfiguration(String name, VertexFormat format, int glMode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setup, Runnable clear) {
        super(name, format, glMode, bufferSize, affectsCrumbling, sortOnUpload, setup, clear);
    }

    public void setupState() {
        super.func_228547_a_();
    }

    public void clearState() {
        super.func_228549_b_();
    }

    public IVertexBuilder begin(IRenderTypeBuffer bufferSource) {
        return bufferSource.getBuffer((RenderType)this);
    }

    public void end(IRenderTypeBuffer.Impl bufferSource) {
        bufferSource.func_228462_a_((RenderType)this);
    }

    public static enum PrimitiveType {
        LINES(1, 2, 2, false),
        LINE_STRIP(3, 2, 1, true),
        TRIANGLE_LINES(4, 2, 2, false),
        TRIANGLE_LINE_STRIP(5, 2, 1, true),
        TRIANGLES(4, 3, 3, false),
        TRIANGLE_STRIP(5, 3, 1, true),
        TRIANGLE_FAN(6, 3, 1, true),
        QUADS(7, 4, 4, false);

        private final int glMode;
        private final int vertexCount;
        private final int vertexOffset;
        private final boolean isConnected;

        private PrimitiveType(int glMode, int vertexCount, int vertexOffset, boolean isConnected) {
            this.glMode = glMode;
            this.vertexCount = vertexCount;
            this.vertexOffset = vertexOffset;
            this.isConnected = isConnected;
        }

        public int getGlMode() {
            return this.glMode;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public int getVertexOffset() {
            return this.vertexOffset;
        }

        public boolean isConnected() {
            return this.isConnected;
        }
    }
}

