/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.deco;

import growthcraft.deco.client.proxy.ClientProxy;
import growthcraft.deco.common.proxy.CommonProxy;
import growthcraft.deco.init.GrowthcraftDecoBlocks;
import growthcraft.deco.init.client.GrowthcraftDecoBlockRenders;
import growthcraft.deco.init.config.GrowthcraftDecoConfig;
import growthcraft.deco.shared.Reference;
import growthcraft.lib.proxy.IProxy;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="growthcraft_deco")
@Mod.EventBusSubscriber(modid="growthcraft_deco", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GrowthcraftDeco {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);

    public GrowthcraftDeco() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        GrowthcraftDecoConfig.loadConfig();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        GrowthcraftDecoBlocks.BLOCKS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
        IForgeRegistry itemRegistry = event.getRegistry();
        Item.Properties properties = new Item.Properties().func_200916_a(Reference.itemGroup);
        GrowthcraftDecoBlocks.registerBlockItems((IForgeRegistry<Item>)itemRegistry, properties);
    }

    private void setup(FMLCommonSetupEvent event) {
        proxy.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        GrowthcraftDecoBlockRenders.setRenderLayers();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"growthcraft_deco", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }
}

