/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.deco.init.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class GrowthcraftDecoConfig {
    public static final String SERVER_CONFIG = String.format("growthcraft-%s-server.toml", "deco");
    public static final String CLIENT_CONFIG = String.format("growthcraft-%s-client.toml", "deco");
    public static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SERVER;
    public static final ForgeConfigSpec CLIENT;

    private GrowthcraftDecoConfig() {
    }

    public static void loadConfig() {
        GrowthcraftDecoConfig.loadConfig(SERVER, FMLPaths.CONFIGDIR.get().resolve(SERVER_CONFIG).toString());
        GrowthcraftDecoConfig.loadConfig(CLIENT, FMLPaths.CONFIGDIR.get().resolve(CLIENT_CONFIG).toString());
    }

    public static void loadConfig(ForgeConfigSpec configSpec, String path) {
        CommentedFileConfig fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        fileConfig.load();
        configSpec.setConfig((CommentedConfig)fileConfig);
    }

    public static void initWorldGenConfig(ForgeConfigSpec.Builder server) {
        server.push("general");
        server.comment(String.format("General configuration for %s.", "Growthcraft Decorations")).define("general.version", (Object)"5.0.0");
        server.pop();
    }

    static {
        GrowthcraftDecoConfig.initWorldGenConfig(SERVER_BUILDER);
        SERVER = SERVER_BUILDER.build();
        CLIENT = CLIENT_BUILDER.build();
    }
}

