/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings.itemdisplay;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ImageButton;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ColorToggleButton;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.SettingsTab;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.itemdisplay.ItemDisplaySettingsContainer;

public class ItemDisplaySettingsTab
extends SettingsTab<ItemDisplaySettingsContainer> {
    private static final TextureBlitData ICON = new TextureBlitData(GuiHelper.ICONS, Dimension.SQUARE_256, new UV(112, 64), Dimension.SQUARE_16);
    private static final List<ITextProperties> ROTATE_TOOLTIP = new ImmutableList.Builder().add((Object)new TranslationTextComponent(TranslationHelper.translSettingsButton("rotate"))).addAll(TranslationHelper.getTranslatedLines(TranslationHelper.translSettingsButton("rotate_detail"), null, TextFormatting.GRAY)).build();
    private static final TextureBlitData ROTATE_FOREGROUND = new TextureBlitData(GuiHelper.ICONS, new Position(1, 1), Dimension.SQUARE_256, new UV(128, 64), Dimension.SQUARE_16);
    public static final ButtonDefinition ROTATE = new ButtonDefinition(Dimension.SQUARE_16, GuiHelper.DEFAULT_BUTTON_BACKGROUND, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND, ROTATE_FOREGROUND, new ITextProperties[0]);

    public ItemDisplaySettingsTab(ItemDisplaySettingsContainer container, Position position, SettingsScreen screen) {
        super(container, position, screen, (ITextComponent)new TranslationTextComponent(TranslationHelper.translSettings("item_display")), (List<ITextProperties>)new ImmutableList.Builder().add((Object)new TranslationTextComponent(TranslationHelper.translSettingsTooltip("item_display"))).addAll(TranslationHelper.getTranslatedLines(TranslationHelper.translSettingsTooltip("item_display") + "_detail", null, TextFormatting.GRAY)).build(), (List<ITextProperties>)new ImmutableList.Builder().add((Object)new TranslationTextComponent(TranslationHelper.translSettingsTooltip("item_display"))).addAll(TranslationHelper.getTranslatedLines(TranslationHelper.translSettingsTooltip("item_display") + "_open_detail", null, TextFormatting.GRAY)).build(), onTabIconClicked -> new ImageButton(new Position(position.getX() + 1, position.getY() + 4), Dimension.SQUARE_16, ICON, (IntConsumer)onTabIconClicked));
        this.addHideableChild(new Button(new Position(this.x + 3, this.y + 24), ROTATE, button -> {
            if (button == 0) {
                container.rotateClockwise();
            } else if (button == 1) {
                container.rotateCounterClockwise();
            }
        }){

            @Override
            protected List<ITextProperties> getTooltip() {
                return ROTATE_TOOLTIP;
            }
        });
        this.addHideableChild(new ColorToggleButton(new Position(this.x + 21, this.y + 24), container::getColor, container::setColor));
    }

    @Override
    public Optional<Integer> getSlotOverlayColor(int slotNumber) {
        return ((ItemDisplaySettingsContainer)this.getSettingsContainer()).isSlotSelected(slotNumber) ? Optional.of(((ItemDisplaySettingsContainer)this.getSettingsContainer()).getColor().getColorValue() | 0x50000000) : Optional.empty();
    }

    @Override
    public void handleSlotClick(Slot slot, int mouseButton) {
        if (mouseButton == 0) {
            ((ItemDisplaySettingsContainer)this.getSettingsContainer()).selectSlot(slot.field_75222_d);
        } else if (mouseButton == 1) {
            ((ItemDisplaySettingsContainer)this.getSettingsContainer()).unselectSlot(slot.field_75222_d);
        }
    }

    @Override
    public int getItemRotation(int slotIndex) {
        return ((ItemDisplaySettingsContainer)this.getSettingsContainer()).getSlot().orElse(-1) == slotIndex ? ((ItemDisplaySettingsContainer)this.getSettingsContainer()).getRotation() : 0;
    }
}

