/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings.nosort;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class NoSortSettingsCategory
implements ISettingsCategory,
ISlotColorCategory {
    public static final String NAME = "no_sort";
    private static final String COLOR_TAG = "color";
    private static final String SELECTED_SLOTS_TAG = "selectedSlots";
    private CompoundNBT categoryNbt;
    private final Consumer<CompoundNBT> saveNbt;
    private final Set<Integer> selectedSlots = new HashSet<Integer>();
    private DyeColor color = DyeColor.LIME;

    public NoSortSettingsCategory(CompoundNBT categoryNbt, Consumer<CompoundNBT> saveNbt) {
        this.categoryNbt = categoryNbt;
        this.saveNbt = saveNbt;
        this.deserialize();
    }

    private void deserialize() {
        for (int slotNumber : this.categoryNbt.func_74759_k(SELECTED_SLOTS_TAG)) {
            this.selectedSlots.add(slotNumber);
        }
        NBTHelper.getInt(this.categoryNbt, COLOR_TAG).ifPresent(c -> {
            this.color = DyeColor.func_196056_a((int)c);
        });
    }

    public boolean isSlotSelected(int slotNumber) {
        return this.selectedSlots.contains(slotNumber);
    }

    public void unselectAllSlots() {
        this.selectedSlots.clear();
        this.serializeSelectedSlots();
    }

    public void selectSlots(int minSlot, int maxSlot) {
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            this.selectedSlots.add(slot);
        }
        this.serializeSelectedSlots();
    }

    public void selectSlot(int slotNumber) {
        this.selectSlots(slotNumber, slotNumber + 1);
    }

    public void unselectSlot(int slotNumber) {
        this.selectedSlots.remove(slotNumber);
        this.serializeSelectedSlots();
    }

    private void serializeSelectedSlots() {
        int[] slots = new int[this.selectedSlots.size()];
        int i = 0;
        for (int slotNumber : this.selectedSlots) {
            slots[i++] = slotNumber;
        }
        this.categoryNbt.func_74783_a(SELECTED_SLOTS_TAG, slots);
        this.saveNbt.accept(this.categoryNbt);
    }

    public void setColor(DyeColor color) {
        this.color = color;
        this.categoryNbt.func_74768_a(COLOR_TAG, color.func_196059_a());
        this.saveNbt.accept(this.categoryNbt);
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public Optional<Integer> getSlotColor(int slotNumber) {
        return this.selectedSlots.contains(slotNumber) ? Optional.of(this.color.getColorValue()) : Optional.empty();
    }

    public Set<Integer> getNoSortSlots() {
        return this.selectedSlots;
    }

    @Override
    public void reloadFrom(CompoundNBT categoryNbt) {
        this.categoryNbt = categoryNbt;
        this.selectedSlots.clear();
        this.color = DyeColor.LIME;
        this.deserialize();
    }
}

