/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.BackpackWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump.FluidFilterContainer;

public class FluidFilterControl
extends BackpackWidget {
    private final FluidFilterContainer container;

    protected FluidFilterControl(Position position, FluidFilterContainer container) {
        super(position);
        this.container = container;
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        GuiHelper.renderSlotsBackground(minecraft, matrixStack, this.x, this.y, this.container.getNumberOfFluidFilters(), 1);
    }

    @Override
    protected void renderWidget(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.container.getNumberOfFluidFilters(); ++i) {
            Fluid fluid = this.container.getFluid(i);
            if (fluid == Fluids.field_204541_a) continue;
            ResourceLocation texture = fluid.getAttributes().getStillTexture();
            TextureAtlasSprite still = (TextureAtlasSprite)this.minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(texture);
            GuiHelper.renderTiledFluidTextureAtlas(matrixStack, still, fluid.getAttributes().getColor(), this.x + i * 18 + 1, this.y + 1, 16, this.minecraft);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int pButton) {
        if (!this.func_231047_b_(mouseX, mouseY)) {
            return false;
        }
        this.getSlotClicked(mouseX, mouseY).ifPresent(this.container::slotClick);
        return true;
    }

    private Optional<Integer> getSlotClicked(double mouseX, double mouseY) {
        if (mouseY < (double)(this.y + 1) || mouseY >= (double)(this.y + 17)) {
            return Optional.empty();
        }
        int index = (int)((mouseX - (double)this.x) / 18.0);
        return Optional.of(index);
    }

    @Override
    public int getWidth() {
        return this.container.getNumberOfFluidFilters() * 18;
    }

    @Override
    public int getHeight() {
        return 18;
    }
}

