/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class CountAbbreviator {
    private static final NavigableMap<Integer, String> COUNT_SUFFIXES = new TreeMap<Integer, String>();
    private static final DecimalFormat TWO_DIGIT_PRECISION;
    private static final DecimalFormat ONE_DIGIT_PRECISION;

    private CountAbbreviator() {
    }

    public static String abbreviate(int count) {
        if (count < 1000) {
            return Integer.toString(count);
        }
        Map.Entry<Integer, String> e = COUNT_SUFFIXES.floorEntry(count);
        Integer divideBy = e.getKey();
        String suffix = e.getValue();
        String numberPart = count < 10 * divideBy ? TWO_DIGIT_PRECISION.format((double)count / (double)divideBy.intValue()) : (count < 100 * divideBy ? ONE_DIGIT_PRECISION.format((double)count / (double)divideBy.intValue()) : Integer.toString(count / divideBy));
        return numberPart + suffix;
    }

    static {
        COUNT_SUFFIXES.put(1000, "k");
        COUNT_SUFFIXES.put(1000000, "m");
        COUNT_SUFFIXES.put(1000000000, "b");
        TWO_DIGIT_PRECISION = new DecimalFormat("#.00");
        TWO_DIGIT_PRECISION.setRoundingMode(RoundingMode.DOWN);
        ONE_DIGIT_PRECISION = new DecimalFormat("##.0");
        ONE_DIGIT_PRECISION.setRoundingMode(RoundingMode.DOWN);
    }
}

