/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;

public class ItemStackKey {
    private final ItemStack stack;
    private static final Field CAP_NBT = ObfuscationReflectionHelper.findField(ItemStack.class, (String)"capNBT");

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemStackKey(ItemStack stack) {
        this.stack = stack.func_77946_l();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackKey that = (ItemStackKey)o;
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)that.stack);
    }

    public int hashCode() {
        return ItemStackKey.getHashCode(this.stack);
    }

    public static int getHashCode(ItemStack stack) {
        CompoundNBT capNbt;
        int hash = stack.func_77973_b().hashCode();
        if (stack.func_77942_o()) {
            hash = hash * 31 + stack.func_77978_p().hashCode();
        }
        if ((capNbt = ItemStackKey.getCapNbt(stack)) != null && !capNbt.isEmpty()) {
            hash = hash * 31 + capNbt.hashCode();
        }
        return hash;
    }

    @Nullable
    private static CompoundNBT getCapNbt(ItemStack stack) {
        try {
            return (CompoundNBT)CAP_NBT.get(stack);
        }
        catch (IllegalAccessException e) {
            SophisticatedBackpacks.LOGGER.error("Error getting capNBT of stack ", (Throwable)e);
            return null;
        }
    }
}

