/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.UUIDCodec;

public class NBTHelper {
    private NBTHelper() {
    }

    public static Optional<Integer> getInt(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74762_e);
    }

    public static Optional<Integer> getInt(CompoundNBT tag, String key) {
        return NBTHelper.getTagValue(tag, key, CompoundNBT::func_74762_e);
    }

    private static <T> Optional<T> getTagValue(ItemStack stack, String key, BiFunction<CompoundNBT, String, T> getValue) {
        return NBTHelper.getTagValue(stack, "", key, getValue);
    }

    public static <T> Optional<T> getTagValue(ItemStack stack, String parentKey, String key, BiFunction<CompoundNBT, String, T> getValue) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return Optional.empty();
        }
        if (!parentKey.isEmpty()) {
            INBT parentTag = tag.func_74781_a(parentKey);
            if (!(parentTag instanceof CompoundNBT)) {
                return Optional.empty();
            }
            tag = (CompoundNBT)parentTag;
        }
        return NBTHelper.getTagValue(tag, key, getValue);
    }

    public static Optional<Boolean> getBoolean(CompoundNBT tag, String key) {
        return NBTHelper.getTagValue(tag, key, CompoundNBT::func_74767_n);
    }

    public static Optional<CompoundNBT> getCompound(CompoundNBT tag, String key) {
        return NBTHelper.getTagValue(tag, key, CompoundNBT::func_74775_l);
    }

    private static <T> Optional<T> getTagValue(CompoundNBT tag, String key, BiFunction<CompoundNBT, String, T> getValue) {
        if (!tag.func_74764_b(key)) {
            return Optional.empty();
        }
        return Optional.of(getValue.apply(tag, key));
    }

    public static <E, C extends Collection<E>> Optional<C> getCollection(ItemStack stack, String parentKey, String tagName, int listType, Function<INBT, Optional<E>> getElement, Supplier<C> initCollection) {
        return NBTHelper.getTagValue(stack, parentKey, tagName, (c, n) -> c.func_150295_c(n, listType)).map(listNbt -> {
            Collection ret = (Collection)initCollection.get();
            listNbt.forEach(elementNbt -> ((Optional)getElement.apply((INBT)elementNbt)).ifPresent(ret::add));
            return ret;
        });
    }

    public static Optional<CompoundNBT> getCompound(ItemStack stack, String parentKey, String tagName) {
        return NBTHelper.getTagValue(stack, parentKey, tagName, CompoundNBT::func_74775_l);
    }

    public static Optional<CompoundNBT> getCompound(ItemStack stack, String tagName) {
        return NBTHelper.getTagValue(stack, tagName, CompoundNBT::func_74775_l);
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(ItemStack stack, String parentKey, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(stack, parentKey, key, (t, k) -> (Enum)deserialize.apply(t.func_74779_i(k)));
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(ItemStack stack, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(stack, key, (CompoundNBT t, String k) -> (Enum)deserialize.apply(t.func_74779_i(k)));
    }

    public static Optional<Boolean> getBoolean(ItemStack stack, String parentKey, String key) {
        return NBTHelper.getTagValue(stack, parentKey, key, CompoundNBT::func_74767_n);
    }

    public static Optional<Boolean> getBoolean(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74767_n);
    }

    public static Optional<Long> getLong(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74763_f);
    }

    public static Optional<UUID> getUniqueId(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, (CompoundNBT compound, String k) -> NBTUtil.func_186860_b((INBT)compound.func_74781_a(k)));
    }

    public static void setCompoundNBT(ItemStack stack, String key, CompoundNBT tag) {
        NBTHelper.setCompoundNBT(stack, "", key, tag);
    }

    public static void setCompoundNBT(ItemStack stack, String parentKey, String key, CompoundNBT tag) {
        if (parentKey.isEmpty()) {
            stack.func_196082_o().func_218657_a(key, (INBT)tag);
            return;
        }
        stack.func_190925_c(parentKey).func_218657_a(key, (INBT)tag);
    }

    public static void setBoolean(ItemStack stack, String parentKey, String key, boolean value) {
        if (parentKey.isEmpty()) {
            NBTHelper.setBoolean(stack, key, value);
            return;
        }
        NBTHelper.putBoolean(stack.func_190925_c(parentKey), key, value);
    }

    public static void setBoolean(ItemStack stack, String key, boolean value) {
        NBTHelper.putBoolean(stack.func_196082_o(), key, value);
    }

    public static <T extends Enum<T>> void setEnumConstant(ItemStack stack, String parentKey, String key, T enumConstant) {
        if (parentKey.isEmpty()) {
            NBTHelper.setEnumConstant(stack, key, enumConstant);
            return;
        }
        NBTHelper.putEnumConstant(stack.func_190925_c(parentKey), key, enumConstant);
    }

    public static <T extends Enum<T>> void setEnumConstant(ItemStack stack, String key, T enumConstant) {
        NBTHelper.putEnumConstant(stack.func_196082_o(), key, enumConstant);
    }

    public static CompoundNBT putBoolean(CompoundNBT tag, String key, boolean value) {
        tag.func_74757_a(key, value);
        return tag;
    }

    public static CompoundNBT putInt(CompoundNBT tag, String key, int value) {
        tag.func_74768_a(key, value);
        return tag;
    }

    public static CompoundNBT putString(CompoundNBT tag, String key, String value) {
        tag.func_74778_a(key, value);
        return tag;
    }

    public static <T extends Enum<T>> CompoundNBT putEnumConstant(CompoundNBT tag, String key, T enumConstant) {
        tag.func_74778_a(key, ((IStringSerializable)enumConstant).func_176610_l());
        return tag;
    }

    public static void setLong(ItemStack stack, String key, long value) {
        stack.func_196082_o().func_74772_a(key, value);
    }

    public static void setInteger(ItemStack stack, String key, int value) {
        stack.func_196082_o().func_74768_a(key, value);
    }

    public static void setUniqueId(ItemStack stack, String key, UUID uuid) {
        stack.func_196082_o().func_74783_a(key, UUIDCodec.func_239777_a_((UUID)uuid));
    }

    public static void removeTag(ItemStack stack, String key) {
        if (stack.func_77978_p() == null) {
            return;
        }
        stack.func_77978_p().func_82580_o(key);
    }

    public static Optional<String> getString(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74779_i);
    }

    public static Optional<Float> getFloat(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74760_g);
    }

    public static <K, V> Optional<Map<K, V>> getMap(ItemStack stack, String key, Function<String, K> getKey, BiFunction<String, INBT, V> getValue) {
        Optional<CompoundNBT> parentTag = NBTHelper.getCompound(stack, key);
        if (!parentTag.isPresent()) {
            return Optional.empty();
        }
        CompoundNBT tag = parentTag.get();
        return NBTHelper.getMap(tag, getKey, (k, v) -> Optional.of(getValue.apply((String)k, (INBT)v)));
    }

    public static <K, V> Optional<Map<K, V>> getMap(CompoundNBT tag, Function<String, K> getKey, BiFunction<String, INBT, Optional<V>> getValue) {
        HashMap map = new HashMap();
        for (String tagName : tag.func_150296_c()) {
            getValue.apply(tagName, tag.func_74781_a(tagName)).ifPresent(value -> map.put(getKey.apply(tagName), value));
        }
        return Optional.of(map);
    }

    public static <K, V> void putMap(CompoundNBT tag, String key, Map<K, V> map, Function<K, String> getStringKey, Function<V, INBT> getNbtValue) {
        CompoundNBT mapNbt = new CompoundNBT();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            mapNbt.func_218657_a(getStringKey.apply(entry.getKey()), getNbtValue.apply(entry.getValue()));
        }
        tag.func_218657_a(key, (INBT)mapNbt);
    }

    public static <K, V> void setMap(ItemStack stack, String key, Map<K, V> map, Function<K, String> getStringKey, Function<V, INBT> getNbtValue) {
        CompoundNBT mapNbt = new CompoundNBT();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            mapNbt.func_218657_a(getStringKey.apply(entry.getKey()), getNbtValue.apply(entry.getValue()));
        }
        stack.func_196082_o().func_218657_a(key, (INBT)mapNbt);
    }

    public static <T> void setList(ItemStack stack, String parentKey, String key, Collection<T> values, Function<T, INBT> getNbtValue) {
        ListNBT list = new ListNBT();
        values.forEach(v -> list.add((Object)((INBT)getNbtValue.apply(v))));
        if (parentKey.isEmpty()) {
            stack.func_196082_o().func_218657_a(key, (INBT)list);
        } else {
            stack.func_190925_c(parentKey).func_218657_a(key, (INBT)list);
        }
    }
}

