/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.CustomComponentParser;
import dev.ftb.mods.ftblibrary.util.ImageComponent;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TextComponentParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ClientTextComponentUtils {
    private static final Function<String, ITextComponent> DEFAULT_STRING_TO_COMPONENT = ClientTextComponentUtils::defaultStringToComponent;
    private static final List<CustomComponentParser> CUSTOM_COMPONENT_PARSERS = new ArrayList<CustomComponentParser>();

    public static void addCustomParser(CustomComponentParser function) {
        CUSTOM_COMPONENT_PARSERS.add(function);
    }

    public static ITextComponent parse(String s) {
        return TextComponentParser.parse(s, DEFAULT_STRING_TO_COMPONENT);
    }

    private static ITextComponent defaultStringToComponent(String s) {
        if (s.isEmpty()) {
            return StringTextComponent.field_240750_d_;
        }
        if (s.indexOf(58) != -1) {
            Map<String, String> map = StringUtils.splitProperties(s);
            for (CustomComponentParser parser : CUSTOM_COMPONENT_PARSERS) {
                ITextComponent c = parser.parse(s, map);
                if (c == null || c == StringTextComponent.field_240750_d_) continue;
                return c;
            }
            if (map.containsKey("image")) {
                ImageComponent c = new ImageComponent();
                c.image = Icon.getIcon(map.get("image"));
                if (map.containsKey("width")) {
                    c.width = Integer.parseInt(map.get("width"));
                }
                if (map.containsKey("height")) {
                    c.height = Integer.parseInt(map.get("height"));
                }
                switch (map.getOrDefault("align", "center").toLowerCase()) {
                    case "left": {
                        c.align = 0;
                        break;
                    }
                    case "center": {
                        c.align = 1;
                        break;
                    }
                    case "right": {
                        c.align = 2;
                    }
                }
                c.fit = map.getOrDefault("fit", "false").equals("true");
                if (map.containsKey("text")) {
                    c.func_240703_c_(Style.field_240709_b_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)ClientTextComponentUtils.parse(map.get("text")))));
                }
                return c;
            }
            if (map.containsKey("open_url")) {
                return ClientTextComponentUtils.parse(map.get("text")).func_230532_e_().func_240703_c_(Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, map.get("open_url"))));
            }
        }
        return ClientTextComponentUtils.parse(I18n.func_135052_a((String)s, (Object[])new Object[0]));
    }
}

