/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.modules.environmental.modules.NoTeleportEModule;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class NoTeleportAreaManager {
    private static final Map<GlobalPos, NoTeleportArea> areas = new HashMap<GlobalPos, NoTeleportArea>();

    public static void markArea(GlobalPos coordinate, int radius, int miny, int maxy) {
        if (areas.containsKey(coordinate)) {
            areas.get(coordinate).touch().setArea(radius, miny, maxy);
        } else {
            NoTeleportArea area = new NoTeleportArea(radius, miny, maxy);
            areas.put(coordinate, area);
        }
    }

    public static boolean isTeleportPrevented(Entity entity, GlobalPos coordinate) {
        if (areas.isEmpty()) {
            return false;
        }
        ArrayList<GlobalPos> toRemove = new ArrayList<GlobalPos>();
        boolean noTeleport = false;
        long curtime = System.currentTimeMillis() - 10000L;
        for (Map.Entry<GlobalPos, NoTeleportArea> entry : areas.entrySet()) {
            BlockPos c;
            ServerWorld world;
            TileEntity te;
            GlobalPos entryCoordinate;
            NoTeleportArea area = entry.getValue();
            if (area.in(coordinate, entryCoordinate = entry.getKey()) && (te = (world = LevelTools.getLevel((World)entity.field_70170_p, (RegistryKey)entryCoordinate.func_239646_a_())).func_175625_s(entryCoordinate.func_218180_b())) instanceof EnvironmentalControllerTileEntity) {
                EnvironmentalControllerTileEntity controllerTileEntity = (EnvironmentalControllerTileEntity)te;
                noTeleport = controllerTileEntity.isEntityAffected(entity);
            }
            if (area.getLastTouched() >= curtime || (world = LevelTools.getLevel((World)entity.field_70170_p, (RegistryKey)entryCoordinate.func_239646_a_())) == null || !LevelTools.isLoaded((World)world, (BlockPos)(c = entryCoordinate.func_218180_b()))) continue;
            boolean removeArea = true;
            TileEntity te2 = world.func_175625_s(c);
            if (te2 instanceof EnvironmentalControllerTileEntity) {
                EnvironmentalControllerTileEntity controllerTileEntity = (EnvironmentalControllerTileEntity)te2;
                for (EnvironmentModule module : controllerTileEntity.getEnvironmentModules()) {
                    if (!(module instanceof NoTeleportEModule) || !((NoTeleportEModule)module).isActive()) continue;
                    removeArea = false;
                    break;
                }
            }
            if (!removeArea) continue;
            toRemove.add(entryCoordinate);
        }
        for (GlobalPos globalCoordinate : toRemove) {
            areas.remove(globalCoordinate);
        }
        return noTeleport;
    }

    public static class NoTeleportArea {
        private float sqradius;
        private int miny;
        private int maxy;
        private long lastTouched;

        public NoTeleportArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            this.touch();
        }

        public NoTeleportArea setArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            return this;
        }

        public String toString() {
            return "NoTeleportArea{sqradius=" + this.sqradius + ", miny=" + this.miny + ", maxy=" + this.maxy + ", lastTouched=" + this.lastTouched + '}';
        }

        public long getLastTouched() {
            return this.lastTouched;
        }

        public NoTeleportArea touch() {
            this.lastTouched = System.currentTimeMillis();
            return this;
        }

        public boolean in(GlobalPos coordinate, GlobalPos thisCoordinate) {
            double pz;
            if (!Objects.equals(coordinate.func_239646_a_(), thisCoordinate.func_239646_a_())) {
                return false;
            }
            double py = coordinate.func_218180_b().func_177956_o();
            if (py < (double)this.miny || py > (double)this.maxy) {
                return false;
            }
            double px = coordinate.func_218180_b().func_177958_n() - thisCoordinate.func_218180_b().func_177958_n();
            double sqdist = px * px + (pz = (double)(coordinate.func_218180_b().func_177952_p() - thisCoordinate.func_218180_b().func_177952_p())) * pz;
            return sqdist < (double)this.sqradius;
        }
    }
}

