/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.modules;

import java.util.ArrayList;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.playerprops.BuffProperties;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BuffEModule
implements EnvironmentModule {
    public static final int MAXTICKS = 180;
    private boolean active = false;
    private int ticks = 180;
    private final PlayerBuff buff;

    public BuffEModule(PlayerBuff buff) {
        this.buff = buff;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void tick(World world, BlockPos pos, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        if (!this.active) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 180;
        double maxsqdist = radius * radius;
        ArrayList players = new ArrayList(world.func_217369_A());
        for (PlayerEntity player : players) {
            double py = player.func_226278_cu_();
            if (!(py >= (double)miny) || !(py <= (double)maxy)) continue;
            double px = player.func_226277_ct_();
            double pz = player.func_226281_cx_();
            double sqdist = (px - (double)pos.func_177958_n()) * (px - (double)pos.func_177958_n()) + (pz - (double)pos.func_177952_p()) * (pz - (double)pos.func_177952_p());
            if (!(sqdist < maxsqdist) || !controllerTileEntity.isPlayerAffected(player)) continue;
            BuffProperties.addBuffToPlayer(player, this.buff, 180);
        }
    }

    @Override
    public boolean apply(World world, BlockPos pos, LivingEntity entity, int duration) {
        return false;
    }

    @Override
    public void activate(boolean a) {
        if (this.active == a) {
            return;
        }
        this.active = a;
        this.ticks = 1;
    }

    public static BuffEModule create(PlayerBuff buff, final double rfPerTick) {
        return new BuffEModule(buff){

            @Override
            public float getRfPerTick() {
                return (float)rfPerTick;
            }
        };
    }
}

