/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apiary.common.tileentity;

import growthcraft.apiary.client.container.BeeBoxContainer;
import growthcraft.apiary.init.GrowthcraftApiaryItems;
import growthcraft.apiary.init.GrowthcraftApiaryTileEntities;
import growthcraft.apiary.init.config.GrowthcraftApiaryConfig;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BeeBoxTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final IItemHandlerModifiable items = this.createHandler();
    private int currentProcessingTime;
    private ITextComponent customName;
    private NonNullList<ItemStack> inventoryItemStacks = NonNullList.func_191197_a((int)28, (Object)ItemStack.field_190927_a);
    private LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);
    private int maxProcessingTime = GrowthcraftApiaryConfig.getBeeBoxMaxProcessingTime();

    public BeeBoxTileEntity() {
        this((TileEntityType)GrowthcraftApiaryTileEntities.BEE_BOX_TILE_ENTITY.get());
    }

    protected BeeBoxTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((IInventory)this);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public void func_73660_a() {
        boolean dirty = false;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.items.getStackInSlot(0).func_190926_b()) {
            SecureRandom random = new SecureRandom();
            if (this.currentProcessingTime >= this.maxProcessingTime) {
                int workers = this.items.getStackInSlot(0).func_190916_E();
                if (workers < 64 && random.nextInt(100) <= GrowthcraftApiaryConfig.getChanceToIncreaseBees()) {
                    this.items.getStackInSlot(0).func_190917_f(1);
                }
                block4: for (int i = 0; i < workers; ++i) {
                    int jobID = random.nextInt(3);
                    switch (jobID) {
                        case 1: {
                            int slotNeedsCombConversion = this.getSlotWithVanillaHoneyComb();
                            if (slotNeedsCombConversion < 0) {
                                slotNeedsCombConversion = this.getSlotWithEmptyHoneyComb();
                            }
                            if (slotNeedsCombConversion <= 0) continue block4;
                            this.inventoryItemStacks.set(slotNeedsCombConversion, (Object)new ItemStack((IItemProvider)GrowthcraftApiaryItems.HONEY_COMB_FULL.get()));
                            continue block4;
                        }
                        case 2: {
                            if (!GrowthcraftApiaryConfig.shouldReplicateFlowers()) continue block4;
                            this.tryReplicateFlower(this.func_174877_v());
                            continue block4;
                        }
                        default: {
                            int emptySlotID = this.getEmptySlot();
                            if (emptySlotID <= 0) continue block4;
                            this.inventoryItemStacks.set(emptySlotID, (Object)new ItemStack((IItemProvider)GrowthcraftApiaryItems.HONEY_COMB_EMPTY.get()));
                        }
                    }
                }
                this.currentProcessingTime = 0;
                dirty = true;
            } else {
                ++this.currentProcessingTime;
            }
        }
        if (dirty) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    private int getSlotWithVanillaHoneyComb() {
        for (int slotID = 0; slotID < this.items.getSlots(); ++slotID) {
            if (((ItemStack)this.inventoryItemStacks.get(slotID)).func_77973_b() != Items.field_226635_pU_) continue;
            return slotID;
        }
        return -1;
    }

    private int getSlotWithEmptyHoneyComb() {
        for (int slotID = 0; slotID < this.items.getSlots(); ++slotID) {
            if (((ItemStack)this.inventoryItemStacks.get(slotID)).func_77973_b() != GrowthcraftApiaryItems.HONEY_COMB_EMPTY.get()) continue;
            return slotID;
        }
        return -1;
    }

    private int getEmptySlot() {
        for (int slotID = 1; slotID < this.items.getSlots(); ++slotID) {
            if (!((ItemStack)this.inventoryItemStacks.get(slotID)).func_190926_b()) continue;
            return slotID;
        }
        return -1;
    }

    private void tryReplicateFlower(BlockPos pos) {
        SecureRandom random = new SecureRandom();
        int maxFlowerRange = GrowthcraftApiaryConfig.getBeeBoxFlowerRange();
        BlockPos posLowerBound = pos.func_177970_e(maxFlowerRange).func_177985_f(maxFlowerRange);
        BlockPos posUpperBound = pos.func_177964_d(maxFlowerRange).func_177965_g(maxFlowerRange);
        ArrayList<BlockPos> flowerBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> emptyBlocks = new ArrayList<BlockPos>();
        Iterable blocksWithinRange = BlockPos.func_218278_a((BlockPos)posLowerBound, (BlockPos)posUpperBound);
        for (BlockPos blockPos : blocksWithinRange) {
            if (BlockTags.func_199896_a().func_199910_a(new ResourceLocation("minecraft", "flowers")).func_230235_a_((Object)this.field_145850_b.func_180495_p(blockPos).func_177230_c())) {
                flowerBlocks.add(blockPos.func_185334_h());
                continue;
            }
            if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != Blocks.field_150350_a || this.field_145850_b.func_180495_p(blockPos.func_177977_b()).func_177230_c() != Blocks.field_196658_i) continue;
            emptyBlocks.add(blockPos.func_185334_h());
        }
        if (random.nextInt(100) <= GrowthcraftApiaryConfig.getChanceToReplicateFlowers()) {
            try {
                if (!flowerBlocks.isEmpty() && !emptyBlocks.isEmpty()) {
                    int randomSourceID = random.nextInt(flowerBlocks.size());
                    int randomTargetID = random.nextInt(emptyBlocks.size());
                    BlockPos randomSourceBlockPos = (BlockPos)flowerBlocks.get(randomSourceID);
                    BlockPos randomEmptyBlockPos = (BlockPos)emptyBlocks.get(randomTargetID);
                    BlockState sourceBlockState = this.field_145850_b.func_180495_p(randomSourceBlockPos);
                    this.field_145850_b.func_180501_a(randomEmptyBlockPos, sourceBlockState, 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IItemHandler getInventory() {
        return this.items;
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.inventoryItemStacks;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.inventoryItemStacks = itemsIn;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_() != null ? this.func_200200_C_() : this.func_213907_g();
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.func_213907_g();
    }

    protected ITextComponent func_213907_g() {
        String translationKey = String.format("container.%s.%s", "growthcraft_apiary", "bee_box");
        return new TranslationTextComponent(translationKey);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BeeBoxContainer(windowId, playerInventory, this);
    }

    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new BeeBoxContainer(windowId, playerInventory, this);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.inventoryItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventoryItemStacks);
        }
        this.currentProcessingTime = compound.func_74762_e("CurrentProcessingTicks");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventoryItemStacks);
        compound.func_74768_a("CurrentProcessingTicks", this.currentProcessingTime);
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return super.getCapability(cap, side);
    }

    public int func_70302_i_() {
        return this.inventoryItemStacks.size();
    }

    public int getCurrentProcessingTime() {
        return this.currentProcessingTime;
    }

    public void setCurrentProcessingTime(int ticks) {
        this.currentProcessingTime = ticks;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public void setMaxProcessingTime(int i) {
        this.maxProcessingTime = i;
    }
}

