/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apiary.init.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class GrowthcraftApiaryConfig {
    public static final String SERVER_CONFIG = String.format("growthcraft-%s-server.toml", "apiary");
    public static final String CLIENT_CONFIG = String.format("growthcraft-%s-client.toml", "apiary");
    public static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SERVER;
    public static final ForgeConfigSpec CLIENT;
    private static final String CATEGORY_BEE_BOX = "beeBox";
    private static ForgeConfigSpec.IntValue bee_box_flower_range;
    private static ForgeConfigSpec.IntValue bee_box_max_processing_time;
    private static ForgeConfigSpec.BooleanValue replicate_flowers;
    private static ForgeConfigSpec.IntValue bee_box_chance_bee_increment;
    private static ForgeConfigSpec.IntValue bee_box_chance_chance_replicate_flower;

    private GrowthcraftApiaryConfig() {
    }

    public static void loadConfig() {
        GrowthcraftApiaryConfig.loadConfig(SERVER, FMLPaths.CONFIGDIR.get().resolve(SERVER_CONFIG).toString());
        GrowthcraftApiaryConfig.loadConfig(CLIENT, FMLPaths.CONFIGDIR.get().resolve(CLIENT_CONFIG).toString());
    }

    public static void loadConfig(ForgeConfigSpec configSpec, String path) {
        CommentedFileConfig fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        fileConfig.load();
        configSpec.setConfig((CommentedConfig)fileConfig);
    }

    public static void initBeeBoxConfig(ForgeConfigSpec.Builder specBuilder) {
        bee_box_flower_range = specBuilder.comment("Set the range for the bee box to look for flowers.").defineInRange(String.format("%s.%s", CATEGORY_BEE_BOX, "flowerRange"), 9, 0, 18);
        bee_box_max_processing_time = specBuilder.comment("Set the process time for the bee box to update. Default is once a minute.").defineInRange(String.format("%s.%s", CATEGORY_BEE_BOX, "maxProcessingTime"), 1200, 200, 1728000);
        bee_box_chance_bee_increment = specBuilder.comment("Set the percentage chance to increment bee population in the Bee Box.").defineInRange(String.format("%s.%s", CATEGORY_BEE_BOX, "chanceBeeIncrement"), 10, 1, 100);
        bee_box_chance_chance_replicate_flower = specBuilder.comment("Set the percentage chance to replicate a flower near by.").defineInRange(String.format("%s.%s", CATEGORY_BEE_BOX, "chanceReplicateFlower"), 10, 1, 100);
        replicate_flowers = specBuilder.comment("Set to false to disable flower replication by the bee box").define(String.format("%s.%s", CATEGORY_BEE_BOX, "replicateFlowers"), true);
    }

    public static int getBeeBoxFlowerRange() {
        return (Integer)bee_box_flower_range.get();
    }

    public static int getBeeBoxMaxProcessingTime() {
        return (Integer)bee_box_max_processing_time.get();
    }

    public static boolean shouldReplicateFlowers() {
        return (Boolean)replicate_flowers.get();
    }

    public static int getChanceToIncreaseBees() {
        return (Integer)bee_box_chance_bee_increment.get();
    }

    public static int getChanceToReplicateFlowers() {
        return (Integer)bee_box_chance_chance_replicate_flower.get();
    }

    static {
        GrowthcraftApiaryConfig.initBeeBoxConfig(SERVER_BUILDER);
        SERVER = SERVER_BUILDER.build();
        CLIENT = CLIENT_BUILDER.build();
    }
}

