/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.container;

import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.tileentity.CultureJarTileEntity;
import growthcraft.cellar.init.GrowthcraftCellarBlocks;
import growthcraft.cellar.init.GrowthcraftCellarContainers;
import growthcraft.lib.util.FunctionalIntReferenceHolder;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class CultureJarContainer
extends Container {
    private final CultureJarTileEntity cultureJarTileEntity;
    private final IWorldPosCallable worldPosCallable;
    private final FunctionalIntReferenceHolder currentProcessingTime;

    public CultureJarContainer(int windowID, PlayerInventory playerInventory, CultureJarTileEntity tileEntity) {
        super((ContainerType)GrowthcraftCellarContainers.culture_jar_container.get(), windowID);
        this.cultureJarTileEntity = tileEntity;
        this.worldPosCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        int index = 0;
        int itemSlotWidth = 18;
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.cultureJarTileEntity.getInventory(), index, 94, 35));
        ++index;
        int hotbarBaseY = 142;
        int hotbarBaseX = 8;
        for (int column = 0; column < 9; ++column) {
            Slot slot = new Slot((IInventory)playerInventory, column, hotbarBaseX + column * itemSlotWidth, hotbarBaseY);
            this.func_75146_a(slot);
            ++index;
        }
        int playerInvBaseY = 84;
        int playerInvBaseX = 8;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int slotIndex = 9 + row * 9 + column;
                Slot slot = new Slot((IInventory)playerInventory, slotIndex, playerInvBaseX + column * itemSlotWidth, playerInvBaseY + row * itemSlotWidth);
                this.func_75146_a(slot);
            }
        }
        this.currentProcessingTime = new FunctionalIntReferenceHolder(this.cultureJarTileEntity::getCurrentProcessingTime, this.cultureJarTileEntity::setCurrentProcessingTime);
        this.func_216958_a(this.currentProcessingTime);
    }

    public CultureJarContainer(int windowID, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(windowID, playerInventory, CultureJarContainer.getTileEntity(playerInventory, packetBuffer));
    }

    private static CultureJarTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        Objects.requireNonNull(playerInventory, "Player inventory cannot be null!");
        Objects.requireNonNull(packetBuffer, "Packet buffer cannot be null!");
        TileEntity tileEntity = playerInventory.field_70458_d.field_70170_p.func_175625_s(packetBuffer.func_179259_c());
        if (tileEntity instanceof CultureJarTileEntity) {
            return (CultureJarTileEntity)tileEntity;
        }
        throw new IllegalStateException("CultureJarContainer found invalid TileEntity: " + tileEntity);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return CultureJarContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)GrowthcraftCellarBlocks.culture_jar.get()));
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack returnStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            returnStack = slotStack.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(slotStack, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == returnStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return returnStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProcessingTimeScaled(int size) {
        GrowthcraftCellar.LOGGER.error(String.format("%d * %d / %d", this.currentProcessingTime.func_221495_b(), size, this.cultureJarTileEntity.getMaxProcessingTime()));
        return this.currentProcessingTime.func_221495_b() != 0 && this.cultureJarTileEntity.getMaxProcessingTime() != 0 ? this.currentProcessingTime.func_221495_b() * size / this.cultureJarTileEntity.getMaxProcessingTime() : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isHeated() {
        return this.cultureJarTileEntity.isHeated();
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidTank getTileEntityFluidTank(int slot) {
        return this.cultureJarTileEntity.getInputFluidTank(0);
    }
}

