/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import growthcraft.cellar.client.container.CultureJarContainer;
import growthcraft.lib.util.ClientUtils;
import growthcraft.lib.util.TextureHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class CultureJarScreen
extends ContainerScreen<CultureJarContainer> {
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_cellar", "culture_jar");

    public CultureJarScreen(CultureJarContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
    }

    private int getScaledFluid(float amount, float capacity, int maxPixelSize) {
        float ratio = amount / capacity;
        float scaled = (float)maxPixelSize * ratio;
        return (int)scaled;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        matrixStack.func_227860_a_();
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        boolean baseX = false;
        boolean baseY = false;
        int maxX = 256;
        int maxY = 256;
        CultureJarScreen.func_238463_a_((MatrixStack)matrixStack, (int)this.field_147003_i, (int)this.field_147009_r, (float)((float)baseX), (float)((float)baseY), (int)this.field_146999_f, (int)this.field_147000_g, (int)maxX, (int)maxY);
        int guiProgressX = this.field_147003_i + 82;
        int guiProgressY = this.field_147009_r + 30;
        this.func_238474_b_(matrixStack, guiProgressX, guiProgressY, 176, 0, 9, ((CultureJarContainer)this.field_147002_h).getProcessingTimeScaled(28));
        int guiHeatLevelX = this.field_147003_i + 96;
        int guiHeatLevelY = this.field_147009_r + 57;
        if (((CultureJarContainer)this.field_147002_h).isHeated()) {
            this.func_238474_b_(matrixStack, guiHeatLevelX, guiHeatLevelY, 176, 28, 13, 13);
        }
        int guiInputFluidTankX = this.field_147003_i + 65;
        int guiInputFluidTankY = this.field_147009_r + 18;
        int guiInputFluidTankHeight = 52;
        if (((CultureJarContainer)this.field_147002_h).getTileEntityFluidTank(0).getFluidAmount() > 0) {
            FluidStack fluidStack = ((CultureJarContainer)this.field_147002_h).getTileEntityFluidTank(0).getFluid();
            int scaledFluidHeight = this.getScaledFluid(fluidStack.getAmount(), ((CultureJarContainer)this.field_147002_h).getTileEntityFluidTank(0).getCapacity(), guiInputFluidTankHeight);
            ClientUtils.drawRepeatedFluidSpriteGui((IRenderTypeBuffer)renderTypeBuffer, matrixStack, fluidStack, guiInputFluidTankX, guiInputFluidTankY + (guiInputFluidTankHeight - scaledFluidHeight), 16.0f, scaledFluidHeight);
        }
        renderTypeBuffer.func_228461_a_();
    }

    @ParametersAreNonnullByDefault
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
    }

    @ParametersAreNonnullByDefault
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int guiInputTankX = this.field_147003_i + 64;
        int guiInputTankY = this.field_147009_r + 17;
        int guiInputTankHeight = 54;
        if (mouseX > guiInputTankX && mouseX < guiInputTankX + 16 && mouseY > guiInputTankY && mouseY < guiInputTankY + guiInputTankHeight) {
            FluidStack fluidStack = ((CultureJarContainer)this.field_147002_h).getTileEntityFluidTank(0).getFluid();
            String tooltip = String.format("%s %dmb", fluidStack.getDisplayName().getString(), fluidStack.getAmount());
            StringTextComponent stringTextComponent = new StringTextComponent(tooltip);
            this.func_238652_a_(matrixStack, (ITextComponent)stringTextComponent, mouseX, mouseY);
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }
}

