/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.tileentity.FermentBarrelTileEntity;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import growthcraft.lib.util.BlockStateUtils;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.GlassBottleItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public class FermentationBarrelBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final VoxelShape VOXEL_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public FermentationBarrelBlock() {
        this(FermentationBarrelBlock.getInitProperties());
    }

    public FermentationBarrelBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    private static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d);
        properties.func_200948_a(2.0f, 3.0f);
        properties.func_226896_b_();
        properties.harvestTool(ToolType.AXE);
        properties.harvestLevel(1);
        properties.func_200947_a(SoundType.field_185848_a);
        return properties;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftCellarTileEntities.barrel_ferment_oak_tileentity.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        if (!(player.func_184586_b(handIn).func_77973_b() instanceof GlassBottleItem) && (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)hit.func_216354_b()) || player.func_184586_b(handIn).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent())) {
            return ActionResultType.SUCCESS;
        }
        if (!worldIn.field_72995_K && player.func_184586_b(handIn).func_77973_b() == Items.field_151069_bo) {
            try {
                FermentBarrelTileEntity tileEntity2 = (FermentBarrelTileEntity)worldIn.func_175625_s(pos);
                if (tileEntity2.getFluidTankHandler().getTank(0).getFluidAmount() >= 250) {
                    tileEntity2.drainTank(0, 250);
                    player.func_184586_b(handIn).func_190918_g(1);
                    ItemStack tileEntityCurrentPotionItemStack = tileEntity2.getCurrentPotionItemStack().func_77946_l();
                    if (!player.field_71071_by.func_70441_a(tileEntityCurrentPotionItemStack)) {
                        player.func_71019_a(tileEntityCurrentPotionItemStack, false);
                    }
                }
            }
            catch (NullPointerException npe) {
                GrowthcraftCellar.LOGGER.error("[Growthcraft-Cellar] NullPointerException thrown while trying to activate FermentBarrel Block with Glass_Bottle.");
            }
            return ActionResultType.SUCCESS;
        }
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof FermentBarrelTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FermentBarrelTileEntity)tileEntity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)BlockStateUtils.getFacingFromEntity(pos, placer)), 2);
        }
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VOXEL_SHAPE;
    }
}

