/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GrowthcraftCellarLootModifier
extends LootModifier {
    private final Item item;

    protected GrowthcraftCellarLootModifier(ILootCondition[] conditionsIn, Item item) {
        super(conditionsIn);
        this.item = item;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        generatedLoot.add(new ItemStack((IItemProvider)this.item, 1));
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<GrowthcraftCellarLootModifier> {
        public GrowthcraftCellarLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"item")));
            return new GrowthcraftCellarLootModifier(lootConditions, item);
        }

        public JsonObject write(GrowthcraftCellarLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.item).toString());
            return json;
        }
    }
}

