/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.recipe;

import growthcraft.cellar.init.GrowthcraftCellarItems;
import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

@MethodsReturnNonnullByDefault
public class BrewKettleRecipe
implements IRecipe<IInventory> {
    private final ResourceLocation recipeId;
    private final FluidStack inputFluidStack;
    private final ItemStack inputItemStack;
    private final FluidStack outputFluidStack;
    private final ItemStack byProduct;
    private final boolean requiresLid;
    private final boolean requiresHeat;
    private final int byProductChance;

    public BrewKettleRecipe(ResourceLocation recipeId, FluidStack inputFluidStack, ItemStack inputItem, FluidStack outputFluidStack, ItemStack byProduct, boolean requiresLid, boolean requiresHeat, int byProductChance) {
        this.recipeId = recipeId;
        this.inputFluidStack = inputFluidStack;
        this.inputItemStack = inputItem;
        this.outputFluidStack = outputFluidStack;
        this.byProduct = byProduct;
        this.requiresLid = requiresLid;
        this.requiresHeat = requiresHeat;
        this.byProductChance = Math.min(byProductChance, 100);
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public boolean matches(ItemStack itemStack, FluidStack fluidStack, boolean needsLid, boolean needsHeat) {
        return this.inputItemStack.func_77973_b() == itemStack.func_77973_b() && this.inputItemStack.func_190916_E() <= itemStack.func_190916_E() && this.inputFluidStack.getFluid() == fluidStack.getFluid() && this.inputFluidStack.getAmount() <= fluidStack.getAmount() && this.requiresLid == needsLid && this.requiresHeat == needsHeat;
    }

    public FluidStack getInputFluidStack() {
        return this.inputFluidStack;
    }

    public FluidStack getOutputFluidStack() {
        return this.outputFluidStack;
    }

    public ItemStack getInputItemStack() {
        return this.inputItemStack;
    }

    public ItemStack getByProduct() {
        return this.byProduct;
    }

    public boolean getLidRequired() {
        return this.requiresLid;
    }

    public boolean isHeatRequired() {
        return this.requiresHeat;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return FluidUtil.getFilledBucket((FluidStack)this.outputFluidStack);
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)GrowthcraftCellarRecipes.BREW_KETTLE_RECIPE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return GrowthcraftCellarRecipes.BREW_KETTLE_RECIPE_TYPE;
    }

    public String func_193358_e() {
        return "growthcraft";
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.requiresLid ? Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.inputItemStack, new ItemStack((IItemProvider)GrowthcraftCellarItems.brew_kettle_lid.get())}) : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.inputItemStack})});
    }

    public int getByProductChance() {
        return this.byProductChance;
    }
}

