/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.recipe;

import com.google.gson.JsonObject;
import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.recipe.CultureJarRecipe;
import growthcraft.lib.util.CraftingUtils;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CultureJarRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<CultureJarRecipe> {
    public CultureJarRecipe read(ResourceLocation recipeId, JsonObject json) {
        int processingTime = JSONUtils.func_151203_m((JsonObject)json, (String)"processing_time");
        boolean needsHeat = JSONUtils.func_151212_i((JsonObject)json, (String)"requires_heat_source");
        FluidStack inputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"input_fluid"));
        ItemStack inputItem = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"input_item"), (boolean)false);
        return new CultureJarRecipe(recipeId, inputFluid, inputItem, processingTime, needsHeat);
    }

    @Nullable
    public CultureJarRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            ItemStack inputItem = buffer.func_150791_c();
            FluidStack inputFluid = buffer.readFluidStack();
            int processingTime = buffer.func_150792_a();
            boolean heat = buffer.readBoolean();
            return new CultureJarRecipe(recipeId, inputFluid, inputItem, processingTime, heat);
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Unable to read recipe from network buffer!");
            throw ex;
        }
    }

    public void write(PacketBuffer buffer, CultureJarRecipe recipe) {
        try {
            buffer.func_150788_a(recipe.getInputItem());
            buffer.writeFluidStack(recipe.getInputFluidStack());
            buffer.func_150787_b(recipe.getProcessingTime());
            buffer.writeBoolean(recipe.isRequiresHeatSource());
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Unable to write recipe from network buffer!");
            throw ex;
        }
    }
}

