/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.client.container.BrewKettleContainer;
import growthcraft.cellar.common.block.BrewKettleBlock;
import growthcraft.cellar.common.recipe.BrewKettleRecipe;
import growthcraft.cellar.common.tileentity.handler.GrowthcraftItemHandler;
import growthcraft.cellar.init.GrowthcraftCellarItems;
import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import growthcraft.cellar.init.config.GrowthcraftCellarConfig;
import growthcraft.lib.common.tank.NonInteractiveTank;
import growthcraft.lib.util.BlockStateUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BrewKettleTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public int maxProcessingTime = GrowthcraftCellarConfig.getDefaultProcessingTime();
    private final GrowthcraftItemHandler inventory;
    private BrewKettleRecipe currentRecipe;
    private int currentSmeltTime;
    private ITextComponent customName;
    private FluidTank inputFluidTank;
    private final LazyOptional<IFluidHandler> inputFluidHandler = LazyOptional.of(() -> this.inputFluidTank);
    private NonInteractiveTank outputFluidTank;
    private final LazyOptional<IFluidHandler> outputFluidHandler = LazyOptional.of(() -> this.outputFluidTank);

    public BrewKettleTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.inventory = new GrowthcraftItemHandler(3, new ItemStack[0]);
        this.createFluidTanks();
    }

    public BrewKettleTileEntity() {
        this((TileEntityType)GrowthcraftCellarTileEntities.brew_kettle_tileentity.get());
    }

    public static Set<IRecipe<?>> findRecipesByType(IRecipeType<?> brewKettleRecipeType, World world) {
        return world != null ? world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g().toString().equals(brewKettleRecipeType.toString())).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Set<IRecipe<?>> findRecipesByType(IRecipeType<?> brewKettleRecipeType) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        return world != null ? world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g().toString().equals(brewKettleRecipeType.toString())).collect(Collectors.toSet()) : Collections.emptySet();
    }

    private void createFluidTanks() {
        this.inputFluidTank = new FluidTank(4000);
        this.outputFluidTank = new NonInteractiveTank(4000);
    }

    public FluidTank getFluidTank(int slot) {
        switch (slot) {
            case 0: {
                return this.inputFluidTank;
            }
            case 1: {
                return this.outputFluidTank;
            }
        }
        return null;
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BrewKettleContainer(windowId, playerInventory, this);
    }

    public void func_73660_a() {
        boolean dirty = false;
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BrewKettleBlock.HAS_LID, (Comparable)Boolean.valueOf(this.hasLid())));
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BrewKettleBlock.LIT, (Comparable)Boolean.valueOf(this.isHeated())));
            if (this.inventory.getStackInSlot(0).func_77973_b() != Items.field_190931_a) {
                BrewKettleRecipe recipe = this.getRecipe(this.inventory.getStackInSlot(0), this.inputFluidTank.getFluid(), this.inventory.getStackInSlot(2).func_77973_b() == GrowthcraftCellarItems.brew_kettle_lid.get());
                if (recipe != null && recipe.isHeatRequired() == this.isHeated()) {
                    if (this.currentRecipe != null && this.currentRecipe == recipe) {
                        ++this.currentSmeltTime;
                        dirty = true;
                    } else if (this.currentRecipe == null && recipe != null) {
                        this.currentSmeltTime = 0;
                        this.currentRecipe = recipe;
                        dirty = true;
                    }
                    if (this.currentSmeltTime > this.maxProcessingTime) {
                        this.inputFluidTank.drain(recipe.getInputFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        this.inventory.getStackInSlot(0).func_190918_g(recipe.getInputItemStack().func_190916_E());
                        this.outputFluidTank.forceFill(recipe.getOutputFluidStack(), IFluidHandler.FluidAction.EXECUTE);
                        if (new Random().nextInt(100) <= recipe.getByProductChance()) {
                            this.inventory.insertItem(1, recipe.getByProduct(), false);
                        }
                        this.currentRecipe = null;
                        this.currentSmeltTime = 0;
                        dirty = true;
                    }
                }
            } else {
                this.currentRecipe = null;
                this.currentSmeltTime = 0;
            }
        }
        if (dirty) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public boolean isHeated() {
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(this.field_145850_b, this.field_174879_c);
        return BlockTags.func_199896_a().func_199910_a(new ResourceLocation("growthcraft", "heatsources")).func_230235_a_((Object)blockMap.get("down"));
    }

    public boolean hasLid() {
        return this.inventory.getStackInSlot(2).func_77973_b() == GrowthcraftCellarItems.brew_kettle_lid.get();
    }

    public ITextComponent func_145748_c_() {
        return this.getName();
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    private ITextComponent getDefaultName() {
        String translationKey = String.format("container.%s.%s", "growthcraft_cellar", "brew_kettle");
        return new TranslationTextComponent(translationKey);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        NonNullList inv = NonNullList.func_191197_a((int)this.inventory.getSlots(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)inv);
        this.inventory.setNonNullList((NonNullList<ItemStack>)inv);
        this.currentSmeltTime = compound.func_74762_e("CurrentSmeltTime");
        this.inputFluidTank.readFromNBT(compound.func_74775_l("inputTank"));
        this.outputFluidTank.readFromNBT(compound.func_74775_l("outputTank"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory.toNonNullList());
        compound.func_74768_a("CurrentSmeltTime", this.currentSmeltTime);
        CompoundNBT inputTankNBT = this.inputFluidTank.writeToNBT(new CompoundNBT());
        compound.func_218657_a("inputTank", (INBT)inputTankNBT);
        CompoundNBT outputTankNBT = this.outputFluidTank.writeToNBT(new CompoundNBT());
        compound.func_218657_a("outputTank", (INBT)outputTankNBT);
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    @Nullable
    private BrewKettleRecipe getRecipe(ItemStack itemStack, FluidStack fluidStack, boolean requiresLid) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftCellarRecipes.BREW_KETTLE_RECIPE_TYPE);
        for (BrewKettleRecipe recipe : recipes) {
            if (!recipe.matches(itemStack, fluidStack, requiresLid, this.isHeated())) continue;
            return recipe;
        }
        return null;
    }

    public final IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side == Direction.UP) {
            return this.inputFluidHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.outputFluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getCurrentSmeltTime() {
        return this.currentSmeltTime;
    }

    public void setCurrentSmeltTime(int smeltTime) {
        this.currentSmeltTime = smeltTime;
    }
}

