/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.client.container.CultureJarContainer;
import growthcraft.cellar.common.block.CultureJarBlock;
import growthcraft.cellar.common.recipe.CultureJarRecipe;
import growthcraft.cellar.common.tileentity.handler.GrowthcraftItemHandler;
import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import growthcraft.lib.util.BlockStateUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CultureJarTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private int maxProcessingTime;
    private int currentProcessingTicks;
    private ITextComponent customName;
    private final GrowthcraftItemHandler inventory;
    private FluidTank inputFluidTank;
    private final LazyOptional<IFluidHandler> inputFluidHandler = LazyOptional.of(() -> this.inputFluidTank);
    private CultureJarRecipe currentRecipe;

    public CultureJarTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.inventory = new GrowthcraftItemHandler(1, new ItemStack[0]);
        this.createFluidTanks();
        this.maxProcessingTime = 600;
        this.currentProcessingTicks = 0;
    }

    public CultureJarTileEntity() {
        this((TileEntityType)GrowthcraftCellarTileEntities.culture_jar_tileentity.get());
    }

    public void func_73660_a() {
        CultureJarRecipe recipe;
        boolean dirty = false;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.inputFluidTank.isEmpty() && (recipe = this.getRecipe(this.inventory.getStackInSlot(0), this.inputFluidTank.getFluid(), this.isHeated())) != null) {
            this.maxProcessingTime = recipe.getProcessingTime();
            if (recipe != this.currentRecipe) {
                this.currentRecipe = recipe;
            } else if (this.currentProcessingTicks >= this.maxProcessingTime) {
                this.processRecipeResult();
                this.currentRecipe = null;
                this.currentProcessingTicks = 0;
            } else {
                ++this.currentProcessingTicks;
            }
            dirty = true;
        }
        if (dirty) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    private void processRecipeResult() {
        this.inputFluidTank.drain(this.currentRecipe.getInputFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        this.inventory.getStackInSlot(0).func_190917_f(this.currentRecipe.getInputItem().func_190916_E());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 256.0;
    }

    public ITextComponent func_145748_c_() {
        return this.getName();
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    private ITextComponent getDefaultName() {
        String translationKey = String.format("container.%s.%s", "growthcraft_cellar", "culture_jar");
        return new TranslationTextComponent(translationKey);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new CultureJarContainer(windowId, playerInventory, this);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        NonNullList inv = NonNullList.func_191197_a((int)this.inventory.getSlots(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)inv);
        this.inventory.setNonNullList((NonNullList<ItemStack>)inv);
        this.currentProcessingTicks = compound.func_74762_e("CurrentProcessingTicks");
        this.inputFluidTank.readFromNBT(compound.func_74775_l("inputTank"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory.toNonNullList());
        compound.func_74768_a("CurrentProcessingTicks", this.currentProcessingTicks);
        CompoundNBT inputTankNBT = this.inputFluidTank.writeToNBT(new CompoundNBT());
        compound.func_218657_a("inputTank", (INBT)inputTankNBT);
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public boolean isHeated() {
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(this.field_145850_b, this.field_174879_c);
        boolean heated = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("growthcraft", "heatsources")).func_230235_a_((Object)blockMap.get("down"));
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)CultureJarBlock.LIT, (Comparable)Boolean.valueOf(heated)));
        return heated;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.inputFluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public final IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    private void createFluidTanks() {
        this.inputFluidTank = new FluidTank(1000);
    }

    public FluidTank getInputFluidTank(int slot) {
        return this.inputFluidTank;
    }

    public static Set<IRecipe<?>> findRecipesByType(IRecipeType<?> cultureJarRecipeType, World world) {
        return world != null ? world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g().toString().equals(cultureJarRecipeType.toString())).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Set<IRecipe<?>> findRecipesByType(IRecipeType<?> cultureJarRecipeType) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        return world != null ? world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g().toString().equals(cultureJarRecipeType.toString())).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @Nullable
    private CultureJarRecipe getRecipe(ItemStack itemStack, FluidStack fluidStack, boolean requiresHeatSource) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftCellarRecipes.CULTURE_JAR_RECIPE_TYPE);
        for (CultureJarRecipe recipe : recipes) {
            if (!recipe.matches(itemStack, fluidStack, requiresHeatSource)) continue;
            return recipe;
        }
        return null;
    }

    public int getCurrentProcessingTime() {
        return this.currentProcessingTicks;
    }

    public void setCurrentProcessingTime(int ticks) {
        this.currentProcessingTicks = ticks;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }
}

