/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.client.container.FermentBarrelContainer;
import growthcraft.cellar.common.recipe.FermentBarrelRecipe;
import growthcraft.cellar.common.tileentity.handler.GrowthcraftItemHandler;
import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import growthcraft.lib.common.tank.handler.FluidTankHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FermentBarrelTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final GrowthcraftItemHandler inventory = new GrowthcraftItemHandler(1, new ItemStack[0]);
    private final FluidTankHandler fluidTankHandler = new FluidTankHandler(1, 8000);
    private int currentProcessingTime = 0;
    private FermentBarrelRecipe currentRecipe;
    private ITextComponent customName;
    private int maxProcessingTime;

    public FermentBarrelTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public FermentBarrelTileEntity() {
        this((TileEntityType)GrowthcraftCellarTileEntities.barrel_ferment_oak_tileentity.get());
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory.toNonNullList();
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.inventory.setNonNullList(itemsIn);
    }

    public void func_73660_a() {
        boolean dirty = false;
        if (!(this.field_145850_b == null || this.field_145850_b.field_72995_K || this.inventory.getStackInSlot(0).func_190926_b() || this.getFluidTank(0).isEmpty())) {
            FermentBarrelRecipe recipe = this.getRecipe(this.inventory.getStackInSlot(0), this.getFluidTank(0).getFluid());
            if (recipe != null) {
                this.maxProcessingTime = recipe.getProcessingTime();
                if (recipe != this.currentRecipe) {
                    this.currentRecipe = recipe;
                } else if (this.currentRecipe.getIngredientItemStack().func_77973_b() == this.inventory.getStackInSlot(0).func_77973_b() && this.currentProcessingTime >= this.maxProcessingTime) {
                    this.processRecipeResult();
                    this.currentProcessingTime = 0;
                } else if (this.currentRecipe.getIngredientItemStack().func_77973_b() == this.inventory.getStackInSlot(0).func_77973_b()) {
                    ++this.currentProcessingTime;
                }
                dirty = true;
            } else if (this.currentProcessingTime > 0) {
                this.currentProcessingTime = 0;
            }
        }
        if (dirty) {
            this.markUpdate();
        }
    }

    private void markUpdate() {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    private void processRecipeResult() {
        Float fluidMultiplier = Float.valueOf((float)this.getFluidTank(0).getFluidAmount() / (float)this.currentRecipe.getResultingFluid().getAmount());
        if (fluidMultiplier.floatValue() % 1.0f == 0.0f) {
            int itemStackShrinkCount = this.currentRecipe.getIngredientItemStack().func_190916_E() * fluidMultiplier.intValue();
            if (this.inventory.getStackInSlot(0).func_190916_E() >= itemStackShrinkCount) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                this.fluidTankHandler.getTank(0).setFluid(FluidStack.EMPTY);
                FluidStack resultFluidStack = this.currentRecipe.getResultingFluid();
                resultFluidStack.setAmount(this.currentRecipe.getResultingFluid().getAmount() * fluidMultiplier.intValue());
                this.fluidTankHandler.getTank(0).setFluid(resultFluidStack);
                this.markUpdate();
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_() != null ? this.func_200200_C_() : this.func_213907_g();
    }

    protected ITextComponent func_213907_g() {
        String translationKey = String.format("container.%s.%s", "growthcraft_cellar", "barrel_ferment");
        return new TranslationTextComponent(translationKey);
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.func_213907_g();
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new FermentBarrelContainer(id, player, this);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        NonNullList inv = NonNullList.func_191197_a((int)this.inventory.getSlots(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)inv);
        this.inventory.setNonNullList((NonNullList<ItemStack>)inv);
        this.currentProcessingTime = compound.func_74762_e("CurrentProcessingTime");
        this.maxProcessingTime = compound.func_74762_e("MaxProcessingTime");
        this.fluidTankHandler.getTank(0).readFromNBT(compound.func_74775_l("tank0"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory.toNonNullList());
        compound.func_74768_a("CurrentProcessingTime", this.currentProcessingTime);
        compound.func_74768_a("MaxProcessingTime", this.maxProcessingTime);
        compound.func_218657_a("tank0", (INBT)this.fluidTankHandler.getTank(0).writeToNBT(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidTankHandler.getFluidTankHandler(0).cast();
        }
        return super.getCapability(cap, side);
    }

    public final IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.inventory.getSlots();
    }

    @Nullable
    public FermentBarrelRecipe getRecipe(ItemStack inputItemStack, FluidStack inputFluidStack) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftCellarRecipes.FERMENT_BARREL_RECIPE_TYPE);
        for (FermentBarrelRecipe recipe : recipes) {
            if (!recipe.matches(inputItemStack, inputFluidStack) && !recipe.matches(inputFluidStack)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public FermentBarrelRecipe getRecipe(FluidStack inputFluidStack) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftCellarRecipes.FERMENT_BARREL_RECIPE_TYPE);
        for (FermentBarrelRecipe recipe : recipes) {
            if (!recipe.matches(inputFluidStack)) continue;
            return recipe;
        }
        return null;
    }

    public int getCurrentProcessingTime() {
        return this.currentProcessingTime;
    }

    public void setCurrentProcessingTime(int ticks) {
        this.currentProcessingTime = ticks;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime > 0 ? this.maxProcessingTime : 9600;
    }

    public FluidTankHandler getFluidTankHandler() {
        return this.fluidTankHandler;
    }

    public FluidTank getFluidTank(int tank) {
        return this.getFluidTankHandler().getTank(tank);
    }

    public void drainTank(int tank, int amount) {
        this.getFluidTank(tank).drain(amount, IFluidHandler.FluidAction.EXECUTE);
        this.markUpdate();
    }

    public ItemStack getCurrentPotionItemStack() {
        return this.currentRecipe.getBottleItemStack();
    }
}

