/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.client.container.FruitPressContainer;
import growthcraft.cellar.common.recipe.FruitPressRecipe;
import growthcraft.cellar.common.tileentity.handler.GrowthcraftItemHandler;
import growthcraft.cellar.init.GrowthcraftCellarRecipes;
import growthcraft.cellar.init.GrowthcraftCellarTileEntities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FruitPressTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private int maxProcessingTime;
    private int currentProcessingTime;
    private ITextComponent customName;
    private final GrowthcraftItemHandler inventory;
    private FluidTank outputFluidTank;
    private final LazyOptional<IFluidHandler> outputFluidHandler = LazyOptional.of(() -> this.outputFluidTank);
    private FruitPressRecipe currentRecipe;

    protected FruitPressTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.inventory = new GrowthcraftItemHandler(1, new ItemStack[0]);
        this.createFluidTanks();
        this.maxProcessingTime = 0;
        this.currentProcessingTime = 0;
    }

    public FruitPressTileEntity() {
        this((TileEntityType)GrowthcraftCellarTileEntities.fruit_press_tileentity.get());
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new FruitPressContainer(windowId, playerInventory, this);
    }

    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new FruitPressContainer(windowId, playerInventory, this);
    }

    public void func_73660_a() {
        FruitPressRecipe fruitPressRecipe;
        boolean dirty = false;
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d() && this.field_145850_b.func_175640_z(this.func_174877_v().func_177984_a()) && !this.inventory.getStackInSlot(0).func_190926_b() && (fruitPressRecipe = this.getRecipe(this.inventory.getStackInSlot(0))) != null) {
            if (this.currentRecipe == null || !this.isTankFull(0)) {
                if (fruitPressRecipe != this.currentRecipe) {
                    this.currentRecipe = fruitPressRecipe;
                    this.maxProcessingTime = fruitPressRecipe.getProcessingTime();
                } else if (this.currentProcessingTime >= this.maxProcessingTime) {
                    this.processRecipeResult();
                    this.currentProcessingTime = 0;
                } else {
                    ++this.currentProcessingTime;
                }
            }
            dirty = true;
        }
        if (dirty) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public boolean isTankFull(int index) {
        try {
            int tankAmount = this.getFluidTank(index).getFluidAmount();
            int outputAmount = this.currentRecipe.getOutputFluidStack().getAmount();
            int tankCapacity = this.getFluidTank(index).getCapacity();
            return this.getFluidTank(index).getFluidAmount() + this.currentRecipe.getOutputFluidStack().getAmount() > this.getFluidTank(0).getCapacity();
        }
        catch (Exception ex) {
            return true;
        }
    }

    private void processRecipeResult() {
        if (!this.isTankFull(0)) {
            this.inventory.getStackInSlot(0).func_190918_g(this.currentRecipe.getInputItemStack().func_190916_E());
            FluidStack resultFluidStack = this.currentRecipe.getOutputFluidStack();
            resultFluidStack.setAmount(this.currentRecipe.getOutputFluidStack().getAmount());
            this.getFluidTank(0).fill(resultFluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public int getCurrentProcessingTime() {
        return this.currentProcessingTime;
    }

    public void setCurrentProcessingTime(int time) {
        this.currentProcessingTime = time;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public void setMaxProcessingTime(int maxTime) {
        this.maxProcessingTime = maxTime;
    }

    public int getPercentageCompleted() {
        int percentage = 0;
        if (this.maxProcessingTime > 0) {
            percentage = this.currentProcessingTime / this.maxProcessingTime * 100;
        }
        return percentage;
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.inventory.toNonNullList();
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.inventory.setNonNullList(itemsIn);
    }

    public int func_70302_i_() {
        return this.inventory.getSlots();
    }

    @Nullable
    public FruitPressRecipe getRecipe(ItemStack inputStack) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftCellarRecipes.FRUIT_PRESS_RECIPE_TYPE);
        for (FruitPressRecipe recipe : recipes) {
            if (!recipe.matches(inputStack)) continue;
            return recipe;
        }
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.outputFluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public final IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    private void createFluidTanks() {
        this.outputFluidTank = new FluidTank(4000);
    }

    public FluidTank getFluidTank(int slot) {
        return this.outputFluidTank;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public void func_213903_a(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.func_213907_g();
    }

    public ITextComponent func_213907_g() {
        String translationKey = String.format("container.%s.%s", "growthcraft_cellar", "fruit_press");
        return new TranslationTextComponent(translationKey);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        NonNullList inv = NonNullList.func_191197_a((int)this.inventory.getSlots(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)inv);
        this.inventory.setNonNullList((NonNullList<ItemStack>)inv);
        this.currentProcessingTime = compound.func_74762_e("CurrentProcessingTime");
        this.outputFluidTank.readFromNBT(compound.func_74775_l("outputTank"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory.toNonNullList());
        compound.func_74768_a("CurrentProcessingTime", this.currentProcessingTime);
        CompoundNBT outputTankNBT = this.outputFluidTank.writeToNBT(new CompoundNBT());
        compound.func_218657_a("outputTank", (INBT)outputTankNBT);
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }
}

