/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.compat.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.recipe.BrewKettleRecipe;
import growthcraft.cellar.init.GrowthcraftCellarBlocks;
import growthcraft.lib.util.TextureHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class BrewKettleRecipeCategory
implements IRecipeCategory<BrewKettleRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("growthcraft_cellar", "brew_kettle");
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_cellar", "brew_kettle");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic overlayHeated;
    private final IDrawableStatic overlayTank;
    private final String title;

    public BrewKettleRecipeCategory(IGuiHelper guiHelper) {
        Block processingBlock = (Block)GrowthcraftCellarBlocks.brew_kettle.get();
        this.background = guiHelper.drawableBuilder(TEXTURE, 10, 10, 160, 70).build();
        this.overlayTank = guiHelper.createDrawable(TEXTURE, 176, 64, 12, 13);
        this.overlayHeated = guiHelper.createDrawable(TEXTURE, 176, 28, 12, 13);
        this.title = I18n.func_135052_a((String)processingBlock.func_149739_a(), (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)processingBlock));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends BrewKettleRecipe> getRecipeClass() {
        return BrewKettleRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BrewKettleRecipe recipe, IIngredients ingredients) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Ingredient ingredient : recipe.func_192400_c()) {
            list.addAll(Arrays.asList(ingredient.func_193365_a()));
        }
        ingredients.setInputs(VanillaTypes.ITEM, list);
        ArrayList<FluidStack> fluidStackIngredients = new ArrayList<FluidStack>();
        fluidStackIngredients.add(recipe.getInputFluidStack());
        ingredients.setInputs(VanillaTypes.FLUID, fluidStackIngredients);
        ArrayList<ItemStack> outputItemStacks = new ArrayList<ItemStack>();
        outputItemStacks.add(recipe.getByProduct());
        ingredients.setOutputs(VanillaTypes.ITEM, outputItemStacks);
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutputFluidStack());
    }

    public void setRecipe(IRecipeLayout layout, BrewKettleRecipe recipe, IIngredients ingredients) {
        try {
            layout.getItemStacks().init(0, true, 69, 24);
            layout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
            if (!((FluidStack)((List)ingredients.getInputs(VanillaTypes.FLUID).get(0)).get(0)).isEmpty()) {
                guiFluidStacks.init(0, true, 36, 7, 16, 52, 4000, false, (IDrawable)this.overlayTank);
                guiFluidStacks.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
            }
            if (!((FluidStack)((List)ingredients.getOutputs(VanillaTypes.FLUID).get(0)).get(0)).isEmpty()) {
                guiFluidStacks.init(1, true, 104, 7, 16, 52, 4000, false, (IDrawable)this.overlayTank);
                guiFluidStacks.set(1, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
            }
            layout.getItemStacks().init(1, true, 130, 6);
            layout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Failure to set recipe mapping for Brew Kettle recipe.");
        }
    }

    public void draw(BrewKettleRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        try {
            if (recipe.isHeatRequired()) {
                this.overlayHeated.draw(matrixStack, 59, 44);
            }
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Failure to draw heat texture for Brew Kettle recipe.");
        }
    }
}

