/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.compat.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.recipe.RoasterRecipe;
import growthcraft.cellar.init.GrowthcraftCellarBlocks;
import growthcraft.lib.util.TextureHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RoasterRecipeCategory
implements IRecipeCategory<RoasterRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("growthcraft_cellar", "roaster");
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_cellar", "roaster");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic overlayHeated;
    private final String title;

    public RoasterRecipeCategory(IGuiHelper guiHelper) {
        Block processingBlock = (Block)GrowthcraftCellarBlocks.roaster.get();
        this.background = guiHelper.drawableBuilder(TEXTURE, 10, 10, 160, 70).build();
        this.overlayHeated = guiHelper.createDrawable(TEXTURE, 176, 28, 12, 13);
        this.title = I18n.func_135052_a((String)processingBlock.func_149739_a(), (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)processingBlock));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends RoasterRecipe> getRecipeClass() {
        return RoasterRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RoasterRecipe recipe, IIngredients ingredients) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Ingredient ingredient : recipe.func_192400_c()) {
            list.addAll(Arrays.asList(ingredient.func_193365_a()));
        }
        ingredients.setInputs(VanillaTypes.ITEM, list);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout layout, RoasterRecipe recipe, IIngredients ingredients) {
        layout.getItemStacks().init(0, true, 42, 31);
        layout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        layout.getItemStacks().init(1, true, 69, 14);
        layout.getItemStacks().set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        layout.getItemStacks().init(2, true, 95, 31);
        layout.getItemStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(RoasterRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        try {
            this.overlayHeated.draw(matrixStack, 71, 47);
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Failure to draw heat texture for Roaster recipe.");
        }
    }
}

