/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.client.container;

import growthcraft.lib.util.FunctionalIntReferenceHolder;
import growthcraft.milk.common.tileentity.PancheonTileEntity;
import growthcraft.milk.init.GrowthcraftMilkBlocks;
import growthcraft.milk.init.GrowthcraftMilkContainers;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class PancheonContainer
extends Container {
    private final PancheonTileEntity tileEntity;
    public FunctionalIntReferenceHolder currentProcessingTime;
    private final IWorldPosCallable canInteractWithCallable;

    public PancheonContainer(int windowID, PlayerInventory playerInventory, PancheonTileEntity tileEntity) {
        super((ContainerType)GrowthcraftMilkContainers.PANCHEON_CONTAINTER.get(), windowID);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        int index = 0;
        int slotWidth = 18;
        int hotbarBaseY = 142;
        int hotbarBaseX = 8;
        for (int column = 0; column < 9; ++column) {
            Slot slot = new Slot((IInventory)playerInventory, column, hotbarBaseX + column * slotWidth, hotbarBaseY);
            this.func_75146_a(slot);
            ++index;
        }
        int playerInvBaseY = 84;
        int playerInvBaseX = 8;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int slotIndex = 9 + row * 9 + column;
                Slot slot = new Slot((IInventory)playerInventory, slotIndex, playerInvBaseX + column * slotWidth, playerInvBaseY + row * slotWidth);
                this.func_75146_a(slot);
            }
        }
        this.currentProcessingTime = new FunctionalIntReferenceHolder(this.tileEntity::getCurrentProcessingTime, this.tileEntity::setCurrentProcessingTime);
        this.func_216958_a(this.currentProcessingTime);
    }

    public PancheonContainer(int windowID, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowID, playerInventory, PancheonContainer.getTileEntity(playerInventory, data));
    }

    private static PancheonTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "Player inventory cannot be null!");
        Objects.requireNonNull(data, "Packet buffer cannot be null!");
        TileEntity tileEntity = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileEntity instanceof PancheonTileEntity) {
            return (PancheonTileEntity)tileEntity;
        }
        throw new IllegalStateException("TileEntity is not correct " + tileEntity);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return PancheonContainer.func_216963_a((IWorldPosCallable)this.canInteractWithCallable, (PlayerEntity)playerIn, (Block)((Block)GrowthcraftMilkBlocks.PANCHEON.get()));
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack returnStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            returnStack = slotStack.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(slotStack, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == returnStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return returnStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressionScaled(int size) {
        return this.currentProcessingTime.func_221495_b() != 0 && this.tileEntity.getMaxProcessingTime() != 0 ? this.currentProcessingTime.func_221495_b() * size / this.tileEntity.getMaxProcessingTime() : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidTank getInputFluidTank(int id) {
        return this.tileEntity.getFluidTank(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidTank getOutputFluidTank(int id) {
        return this.tileEntity.getFluidTank(id);
    }
}

