/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import growthcraft.lib.util.CraftingUtils;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.recipe.PancheonRecipe;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PancheonRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<PancheonRecipe> {
    @MethodsReturnNonnullByDefault
    @ParametersAreNonnullByDefault
    public PancheonRecipe read(ResourceLocation recipeId, JsonObject json) {
        FluidStack inputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"input_fluid"));
        JsonArray outputFluids = JSONUtils.func_151214_t((JsonObject)json, (String)"output_fluids");
        FluidStack outputFluid1 = CraftingUtils.getFluidStack(outputFluids.get(0).getAsJsonObject());
        FluidStack outputFluid2 = CraftingUtils.getFluidStack(outputFluids.get(1).getAsJsonObject());
        int processingTime = JSONUtils.func_151208_a((JsonObject)json, (String)"processing_time", (int)1200);
        return new PancheonRecipe(recipeId, inputFluid, outputFluid1, outputFluid2, processingTime);
    }

    @Nullable
    public PancheonRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            FluidStack inputFluid = buffer.readFluidStack();
            FluidStack outputFluid1 = buffer.readFluidStack();
            FluidStack outputFluid2 = buffer.readFluidStack();
            int processingTime = buffer.func_150792_a();
            return new PancheonRecipe(recipeId, inputFluid, outputFluid1, outputFluid2, processingTime);
        }
        catch (Exception ex) {
            String message = String.format("Unable to read recipe (%s) from network buffer.", recipeId);
            GrowthcraftMilk.LOGGER.error(message);
            throw ex;
        }
    }

    public void write(PacketBuffer buffer, PancheonRecipe recipe) {
        buffer.writeFluidStack(recipe.getInputFluidStack());
        buffer.writeFluidStack(recipe.getOutputFluidStack(0));
        buffer.writeFluidStack(recipe.getOutputFluidStack(1));
        buffer.func_150787_b(recipe.getProcessingTime());
    }
}

