/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.milk.common.recipe.CheesePressRecipe;
import growthcraft.milk.init.GrowthcraftMilkRecipes;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import growthcraft.milk.lib.common.block.CheeseWheelBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;

public class CheeseWheelTileEntity
extends TileEntity
implements ITickableTileEntity {
    private boolean aged = true;
    private int sliceCountTop = 0;
    private int sliceCountBottom = 4;
    private int currentAging = 0;
    private static final int MAX_AGING = 72000;

    public CheeseWheelTileEntity() {
        this((TileEntityType)GrowthcraftMilkTileEntities.CHEESE_WHEEL_TILE_ENTITY.get());
    }

    public CheeseWheelTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d() && Boolean.FALSE.equals(this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)CheeseWheelBlock.AGED))) {
            if (this.currentAging < 72000) {
                ++this.currentAging;
            } else {
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)CheeseWheelBlock.AGED, (Comparable)Boolean.valueOf(true)));
                this.currentAging = 0;
            }
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    private void setBlockState(int bottomSlices, int topSlices) {
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)CheeseWheelBlock.SLICE_COUNT_TOP, (Comparable)Integer.valueOf(topSlices))).func_206870_a((Property)CheeseWheelBlock.SLICE_COUNT_BOTTOM, (Comparable)Integer.valueOf(bottomSlices)));
    }

    public boolean canTakeSlice() {
        return this.aged && this.getSliceCount() > 0;
    }

    public ItemStack takeSlice() {
        List cheesePressRecipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftMilkRecipes.CHEESE_PRESS_RECIPE_TYPE);
        for (CheesePressRecipe cheesePressRecipe : cheesePressRecipes) {
            if (!cheesePressRecipe.matchesOutput(new ItemStack((IItemProvider)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_199767_j()))) continue;
            this.takeSlice(1);
            return cheesePressRecipe.getSliceItem();
        }
        return null;
    }

    public void takeSlice(int count) {
        if (this.sliceCountTop > 0) {
            this.sliceCountTop -= count;
        } else if (this.sliceCountBottom > 0) {
            this.sliceCountBottom -= count;
        }
        this.setBlockState(this.sliceCountBottom, this.sliceCountTop);
    }

    public void addSlice(int count) {
        int newTotal = this.sliceCountBottom + this.sliceCountTop + count;
        if (newTotal > 4) {
            this.sliceCountBottom = 4;
            this.sliceCountTop = newTotal - this.sliceCountBottom;
        } else {
            this.sliceCountBottom = newTotal;
            this.sliceCountTop = 0;
        }
        this.setBlockState(this.sliceCountBottom, this.sliceCountTop);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.sliceCountTop = compound.func_74762_e("slicestop");
        this.sliceCountBottom = compound.func_74762_e("slicesbottom");
        this.aged = compound.func_74767_n("aged");
        this.currentAging = compound.func_74762_e("CurrentAging");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("slicestop", this.sliceCountTop);
        compound.func_74768_a("slicesbottom", this.sliceCountBottom);
        compound.func_74757_a("aged", this.aged);
        compound.func_74768_a("CurrentAging", this.currentAging);
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public int getSliceCount() {
        return this.sliceCountBottom + this.sliceCountTop;
    }
}

