/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.lib.common.tank.handler.FluidTankHandler;
import growthcraft.lib.common.tank.handler.FluidTankOutputHandler;
import growthcraft.milk.client.container.PancheonContainer;
import growthcraft.milk.common.block.PancheonBlock;
import growthcraft.milk.common.recipe.PancheonRecipe;
import growthcraft.milk.init.GrowthcraftMilkRecipes;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class PancheonTileEntity
extends LockableLootTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private int currentProcessingTime;
    private ITextComponent customName;
    private FluidTankHandler inputFluidTankHandler;
    private boolean locked = false;
    private int maxProcessingTime;
    private FluidTankOutputHandler outputFluidTankHandler;
    private PancheonRecipe currentRecipe;

    public PancheonTileEntity() {
        this((TileEntityType)GrowthcraftMilkTileEntities.PANCHEON_TILE_ENTITY.get());
    }

    public PancheonTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.createFluidTanks();
    }

    public void func_73660_a() {
        boolean dirty = false;
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            if (this.currentProcessingTime > 0) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)PancheonBlock.LOCKED, (Comparable)Boolean.valueOf(true)));
            } else {
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)PancheonBlock.LOCKED, (Comparable)Boolean.valueOf(false)));
            }
            if (!this.inputFluidTankHandler.getTank(0).isEmpty()) {
                PancheonRecipe recipe = this.getRecipe(this.inputFluidTankHandler.getTank(0).getFluid());
                if (recipe != null) {
                    if (recipe != this.currentRecipe && this.inputFluidTankHandler.getTank(0).getFluidAmount() >= recipe.getInputFluidStack().getAmount()) {
                        this.currentRecipe = recipe;
                        this.currentProcessingTime = 0;
                        this.maxProcessingTime = recipe.getProcessingTime();
                        dirty = true;
                    } else if (this.inputFluidTankHandler.getTank(0).getFluidAmount() >= recipe.getInputFluidStack().getAmount()) {
                        ++this.currentProcessingTime;
                        dirty = true;
                    }
                    if (this.currentProcessingTime > this.maxProcessingTime) {
                        this.inputFluidTankHandler.getTank(0).drain(recipe.getInputFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        this.outputFluidTankHandler.getTank(0).forceFill(recipe.getOutputFluidStack(0), IFluidHandler.FluidAction.EXECUTE);
                        this.outputFluidTankHandler.getTank(1).forceFill(recipe.getOutputFluidStack(1), IFluidHandler.FluidAction.EXECUTE);
                        this.currentRecipe = null;
                        this.currentProcessingTime = 0;
                        dirty = true;
                    }
                }
            } else {
                this.currentRecipe = null;
                this.currentProcessingTime = 0;
            }
            if (dirty) {
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
            }
        }
    }

    @Nullable
    @ParametersAreNonnullByDefault
    private PancheonRecipe getRecipe(FluidStack fluidStack) {
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(GrowthcraftMilkRecipes.PANCHEON_RECIPE_TYPE);
        for (PancheonRecipe recipe : recipes) {
            if (!recipe.matches(fluidStack)) continue;
            return recipe;
        }
        return null;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.func_213907_g();
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        String translationKey = String.format("container.%s.%s", "growthcraft_milk", "pancheon");
        return new TranslationTextComponent(translationKey);
    }

    @Nonnull
    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        return new PancheonContainer(windowId, playerInventory, this);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return null;
    }

    protected void func_199721_a(NonNullList<ItemStack> nonNullList) {
    }

    private void createFluidTanks() {
        this.inputFluidTankHandler = new FluidTankHandler(1, 2000);
        this.outputFluidTankHandler = new FluidTankOutputHandler(2, 1000);
    }

    public FluidTank getFluidTank(int slot) {
        switch (slot) {
            case 0: {
                return this.inputFluidTankHandler.getTank(0);
            }
            case 1: {
                return this.outputFluidTankHandler.getTank(0);
            }
            case 2: {
                return this.outputFluidTankHandler.getTank(1);
            }
        }
        return null;
    }

    public int func_70302_i_() {
        return 0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.currentProcessingTime = compound.func_74762_e("CurrentProcessingTime");
        this.maxProcessingTime = compound.func_74762_e("MaxProcessingTime");
        this.locked = compound.func_74767_n("IsLocked");
        this.inputFluidTankHandler.getTank(0).readFromNBT(compound.func_74775_l("tank0"));
        this.outputFluidTankHandler.getTank(0).readFromNBT(compound.func_74775_l("tank1"));
        this.outputFluidTankHandler.getTank(1).readFromNBT(compound.func_74775_l("tank2"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_74768_a("CurrentProcessingTime", this.currentProcessingTime);
        compound.func_74768_a("MaxProcessingTime", this.maxProcessingTime);
        compound.func_74757_a("IsLocked", this.isLocked());
        compound.func_218657_a("tank0", (INBT)this.inputFluidTankHandler.getTank(0).writeToNBT(new CompoundNBT()));
        compound.func_218657_a("tank1", (INBT)this.outputFluidTankHandler.getTank(0).writeToNBT(new CompoundNBT()));
        compound.func_218657_a("tank2", (INBT)this.outputFluidTankHandler.getTank(1).writeToNBT(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.isLocked() && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            int inputFluidAmount = this.inputFluidTankHandler.getTank(0).getFluidAmount();
            int outputFluidAmount0 = this.outputFluidTankHandler.getTank(0).getFluidAmount();
            int outputFluidAmount1 = this.outputFluidTankHandler.getTank(1).getFluidAmount();
            if (inputFluidAmount > 0 || inputFluidAmount + outputFluidAmount0 + outputFluidAmount1 == 0) {
                return this.inputFluidTankHandler.getFluidTankHandler(0).cast();
            }
            if (inputFluidAmount == 0 && outputFluidAmount0 > 0) {
                return this.outputFluidTankHandler.getFluidTankHandler(0).cast();
            }
            if (inputFluidAmount == 0 && outputFluidAmount0 == 0 && outputFluidAmount1 > 0) {
                return this.outputFluidTankHandler.getFluidTankHandler(1).cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getCurrentProcessingTime() {
        return this.currentProcessingTime;
    }

    public void setCurrentProcessingTime(int processingTime) {
        this.currentProcessingTime = processingTime;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public boolean isFluidEmpty() {
        return this.inputFluidTankHandler.getTank(0).isEmpty() && this.outputFluidTankHandler.getTank(0).isEmpty() && this.outputFluidTankHandler.getTank(1).isEmpty();
    }
}

