/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.compat.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import growthcraft.lib.util.TextureHelper;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.recipe.ChurnRecipe;
import growthcraft.milk.init.GrowthcraftMilkBlocks;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ChurnRecipeCategory
implements IRecipeCategory<ChurnRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("growthcraft_milk", "churn");
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_milk", "churn");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic overlayTransferArrow;
    private final IDrawableStatic overlayTank;
    private final String title;

    public ChurnRecipeCategory(IGuiHelper guiHelper) {
        Block processingBlock = (Block)GrowthcraftMilkBlocks.CHURN.get();
        this.background = guiHelper.drawableBuilder(TEXTURE, 10, 10, 160, 70).build();
        this.overlayTransferArrow = guiHelper.createDrawable(TEXTURE, 51, 170, 12, 7);
        this.overlayTank = guiHelper.createDrawable(TEXTURE, 176, 64, 12, 13);
        this.title = I18n.func_135052_a((String)processingBlock.func_149739_a(), (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)processingBlock));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends ChurnRecipe> getRecipeClass() {
        return ChurnRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ChurnRecipe recipe, IIngredients ingredients) {
        ArrayList<FluidStack> fluidStackIngredients = new ArrayList<FluidStack>();
        fluidStackIngredients.add(recipe.getInputFluidStack());
        ingredients.setInputs(VanillaTypes.FLUID, fluidStackIngredients);
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutputFluidStack());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout layout, ChurnRecipe recipe, IIngredients ingredients) {
        layout.getItemStacks().init(0, true, 83, 24);
        layout.getItemStacks().set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiFluidStacks.init(0, true, 55, 8, 8, 52, 1000, false, (IDrawable)this.overlayTank);
        guiFluidStacks.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        guiFluidStacks.init(1, true, 63, 8, 8, 52, 1000, false, (IDrawable)this.overlayTank);
        guiFluidStacks.set(1, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
    }

    public void draw(ChurnRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        try {
            this.overlayTransferArrow.draw(matrixStack, 57, 29);
        }
        catch (Exception ex) {
            GrowthcraftMilk.LOGGER.error("Failure to draw heat texture for Churn recipe.");
        }
    }
}

