/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.lib.common.block;

import java.awt.Color;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class CheeseCurdBlock
extends Block
implements IForgeShearable {
    public static final VoxelShape BASE_BOUNDING_BOX = Block.func_208617_a((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    private final int color;

    public CheeseCurdBlock(Color color) {
        super(CheeseCurdBlock.getInitProperties());
        this.color = color.getRGB();
    }

    private static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196556_aL);
        properties.func_200943_b(1.5f);
        properties.func_226896_b_();
        properties.harvestLevel(1);
        return properties;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{AGE});
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public int getMaxAge() {
        return 7;
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        int i = this.getAge(state);
        worldIn.func_180501_a(pos, this.withAge(i + 1), 2);
    }

    public boolean func_149653_t(BlockState state) {
        return !this.isMaxAge(state);
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return !world.func_175623_d(pos.func_177984_a());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BASE_BOUNDING_BOX;
    }

    public int getColor(int i) {
        return i == 0 ? this.color : 0xFFFFFF;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        ItemStack heldItemStack = player.func_184586_b(hand);
        if (heldItemStack.func_77973_b() == Items.field_151097_aZ && (Integer)state.func_177229_b((Property)AGE) != 7) {
            worldIn.func_217378_a(player, 2001, pos, CheeseCurdBlock.func_196246_j((BlockState)state));
            ItemStack itemStack = new ItemStack((IItemProvider)state.func_177230_c(), 1);
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack);
            worldIn.func_217377_a(pos, true);
            return ActionResultType.PASS;
        }
        if (heldItemStack.func_77973_b() == Items.field_151097_aZ && (Integer)state.func_177229_b((Property)AGE) == 7) {
            worldIn.func_175655_b(pos, true);
        }
        return super.func_225533_a_(state, worldIn, pos, player, hand, hitResult);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        BlockPos blockpos;
        if ((Integer)state.func_177229_b((Property)AGE) < 7 && random.nextInt(16) <= 4 && world.func_175623_d(blockpos = pos.func_177977_b())) {
            double d0 = (double)pos.func_177958_n() + random.nextDouble() / 2.0;
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (double)pos.func_177952_p() + random.nextDouble() / 2.0;
            world.func_195594_a((IParticleData)ParticleTypes.field_229428_ah_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

