/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.rice.common.block;

import growthcraft.rice.init.GrowthcraftRiceBlocks;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class CultivatedFarmlandBlock
extends Block
implements IWaterLoggable {
    public static final IntegerProperty MOISTURE = BlockStateProperties.field_208133_ah;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public CultivatedFarmlandBlock() {
        super(CultivatedFarmlandBlock.getInitProperties());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)MOISTURE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150458_ak);
        properties.harvestTool(ToolType.HOE);
        properties.func_226896_b_();
        return properties;
    }

    public static void turnToDirt(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, CultivatedFarmlandBlock.func_199601_a((BlockState)state, (BlockState)Blocks.field_150346_d.func_176223_P(), (World)worldIn, (BlockPos)pos));
    }

    private static boolean hasWater(IWorldReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!worldIn.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)worldIn, (BlockPos)pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{MOISTURE, WATERLOGGED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177984_a());
        return !blockstate.func_185904_a().func_76220_a() || blockstate.func_177230_c() instanceof FenceGateBlock || blockstate.func_177230_c() instanceof MovingPistonBlock;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getActualBlockState(context);
    }

    public BlockState getActualBlockState(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? Blocks.field_150346_d.func_176223_P() : (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)MOISTURE, (Comparable)Integer.valueOf(this.getMoistureLevel(context.func_195991_k(), context.func_195995_a())))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            CultivatedFarmlandBlock.turnToDirt(state, (World)worldIn, pos);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        boolean flooded = worldIn.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a || this.getMoistureLevel((World)worldIn, pos) == 7;
        worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)MOISTURE, (Comparable)Integer.valueOf(this.getMoistureLevel((World)worldIn, pos)))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flooded)), 2);
    }

    public int getMoistureLevel(World worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        try {
            int i = (Integer)state.func_177229_b((Property)MOISTURE);
            if (!CultivatedFarmlandBlock.hasWater((IWorldReader)worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
                if (i > 0) {
                    return i - 1;
                }
                if (!this.hasCrops((IBlockReader)worldIn, pos)) {
                    CultivatedFarmlandBlock.turnToDirt(state, worldIn, pos);
                }
            } else if (i < 7) {
                return 7;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && ForgeHooks.onFarmlandTrample((World)worldIn, (BlockPos)pos, (BlockState)Blocks.field_150346_d.func_176223_P(), (float)fallDistance, (Entity)entityIn)) {
            CultivatedFarmlandBlock.turnToDirt(worldIn.func_180495_p(pos), worldIn, pos);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    private boolean hasCrops(IBlockReader worldIn, BlockPos pos) {
        BlockState plant = worldIn.func_180495_p(pos.func_177984_a());
        BlockState state = worldIn.func_180495_p(pos);
        return plant.func_177230_c() instanceof IPlantable && state.canSustainPlant(worldIn, pos, Direction.UP, (IPlantable)plant.func_177230_c());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos);
        if (plant.func_177230_c() == GrowthcraftRiceBlocks.RICE_CROP.get()) {
            return (Boolean)state.func_177229_b((Property)WATERLOGGED);
        }
        return false;
    }
}

