/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.rice.init;

import growthcraft.lib.util.FluidUtils;
import growthcraft.rice.common.block.CultivatedFarmlandBlock;
import growthcraft.rice.common.block.RiceCropBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GrowthcraftRiceBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"growthcraft_rice");
    public static final RegistryObject<CultivatedFarmlandBlock> CULTIVATED_FARMLAND = BLOCKS.register("cultivated_farmland", CultivatedFarmlandBlock::new);
    public static final RegistryObject<RiceCropBlock> RICE_CROP = BLOCKS.register("rice_crop", RiceCropBlock::new);

    public static void registerBlockItems(IForgeRegistry<Item> itemRegistry, Item.Properties properties) {
        BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            BlockItem blockItem = new BlockItem(block, properties);
            if (block.getRegistryName() != null && !GrowthcraftRiceBlocks.excludeBlockItemRegistry(block.getRegistryName())) {
                blockItem.setRegistryName(block.getRegistryName());
                itemRegistry.register((IForgeRegistryEntry)blockItem);
            }
        });
    }

    private static boolean excludeBlockItemRegistry(ResourceLocation registryName) {
        ArrayList<String> excludeBlocks = new ArrayList<String>();
        excludeBlocks.add("growthcraft_rice:" + FluidUtils.getFluidNames("rice_water").get("block"));
        excludeBlocks.add("growthcraft_rice:" + FluidUtils.getFluidNames("rice_wine").get("block"));
        excludeBlocks.add("growthcraft_rice:" + FluidUtils.getFluidNames("sake").get("block"));
        return excludeBlocks.contains(registryName.toString());
    }
}

