/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;

public abstract class AbstractChaosMachineTileEntity<R extends IRecipe<?>>
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity {
    protected int progress;
    protected int processTime;
    protected int chaosGenerated;
    protected int chaosBuffer;
    protected final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractChaosMachineTileEntity.this.progress;
                }
                case 1: {
                    return AbstractChaosMachineTileEntity.this.processTime;
                }
                case 2: {
                    return AbstractChaosMachineTileEntity.this.chaosGenerated & 0xFFFF;
                }
                case 3: {
                    return AbstractChaosMachineTileEntity.this.chaosGenerated >> 16 & 0xFFFF;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractChaosMachineTileEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AbstractChaosMachineTileEntity.this.processTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };

    protected AbstractChaosMachineTileEntity(TileEntityType<?> typeIn, int inventorySize) {
        super(typeIn, inventorySize);
    }

    protected abstract int[] getOutputSlots();

    @Nullable
    protected abstract R getRecipe();

    protected abstract int getChaosGenerated(R var1);

    protected abstract int getProcessTime(R var1);

    protected abstract ItemStack getProcessResult(R var1);

    protected void sendUpdate() {
        if (this.field_145850_b == null) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    protected void setInactiveState() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.progress > 0) {
            this.progress = 0;
            this.sendUpdate();
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        R recipe = this.getRecipe();
        if (recipe != null && this.canMachineRun(recipe)) {
            ++this.progress;
            this.processTime = this.getProcessTime(recipe);
            this.chaosGenerated = this.getChaosGenerated(recipe);
            this.chaosBuffer += this.chaosGenerated;
            if (this.progress >= this.processTime) {
                this.storeResultItem(this.getProcessResult(recipe));
                this.consumeIngredients(recipe);
                if (this.getRecipe() == null) {
                    this.setInactiveState();
                } else {
                    this.progress = 0;
                }
            }
        } else {
            this.setNeutralState();
        }
        if (this.chaosBuffer > 0 && this.field_145850_b.func_82737_E() % 20L == 0L) {
            Chaos.generate((ICapabilityProvider)this.field_145850_b, this.chaosBuffer, this.field_174879_c);
            this.chaosBuffer = 0;
        }
    }

    private void setNeutralState() {
        boolean update = this.progress > 0 || this.chaosGenerated > 0;
        this.progress = 0;
        this.chaosGenerated = 0;
        if (update) {
            this.sendUpdate();
        }
    }

    private boolean canMachineRun(R recipe) {
        return this.field_145850_b != null && this.hasRoomForOutputItem(this.getProcessResult(recipe));
    }

    private boolean hasRoomForOutputItem(ItemStack stack) {
        for (int i : this.getOutputSlots()) {
            ItemStack output = this.func_70301_a(i);
            if (!AbstractChaosMachineTileEntity.canItemsStack(stack, output)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canItemsStack(ItemStack a, ItemStack b) {
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b) && a.func_190916_E() + b.func_190916_E() <= a.func_77976_d();
    }

    private void storeResultItem(ItemStack stack) {
        for (int i : this.getOutputSlots()) {
            ItemStack output = this.func_70301_a(i);
            if (!AbstractChaosMachineTileEntity.canItemsStack(stack, output)) continue;
            if (output.func_190926_b()) {
                this.func_70299_a(i, stack);
            } else {
                output.func_190920_e(output.func_190916_E() + stack.func_190916_E());
            }
            return;
        }
    }

    protected abstract void consumeIngredients(R var1);

    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        this.readData(tags);
    }

    private void readData(CompoundNBT tags) {
        this.progress = tags.func_74762_e("Progress");
        this.processTime = tags.func_74762_e("ProcessTime");
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        this.writeData(tags);
        return tags;
    }

    private void writeData(CompoundNBT tags) {
        tags.func_74768_a("Progress", this.progress);
        tags.func_74768_a("ProcessTime", this.processTime);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        CompoundNBT tags = packet.func_148857_g();
        this.readData(tags);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        this.writeData(tags);
        return tags;
    }
}

