/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Locale;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.registry.BlockRegistryObject;

public enum HardenedRock implements IBlockProvider
{
    STONE,
    NETHERRACK,
    END_STONE;

    private BlockRegistryObject<Block> block;

    public static void registerBlocks() {
        for (HardenedRock rock : HardenedRock.values()) {
            rock.block = new BlockRegistryObject(Registration.BLOCKS.register(rock.getName(), HardenedRockBlock::new));
            Registration.ITEMS.register(rock.getName(), GemsBlocks.defaultItem(rock.block));
        }
    }

    public Block asBlock() {
        return (Block)this.block.get();
    }

    public String getName() {
        return "hardened_" + this.name().toLowerCase(Locale.ROOT);
    }

    public static class HardenedRockBlock
    extends Block {
        HardenedRockBlock() {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(50.0f, 2000.0f).harvestTool(ToolType.PICKAXE));
        }

        public int getHarvestLevel(BlockState state) {
            return 3;
        }
    }
}

