/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Locale;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.lib.advancements.LibTriggers;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.registry.BlockRegistryObject;

public enum MiscBlocks implements IBlockProvider
{
    CHAOS_CRYSTAL(CraftingItems.CHAOS_CRYSTAL, MiscBlocks.builder(Material.field_151573_f)),
    ENRICHED_CHAOS_CRYSTAL(CraftingItems.ENRICHED_CHAOS_CRYSTAL, MiscBlocks.builder(Material.field_151573_f)),
    ENDER_CRYSTAL(CraftingItems.ENDER_CRYSTAL, MiscBlocks.builder(Material.field_151573_f)),
    CHAOS_COAL(CraftingItems.CHAOS_COAL, MiscBlocks.builder(Material.field_151576_e).func_200947_a(SoundType.field_185851_d)),
    SILVER(CraftingItems.SILVER_INGOT, MiscBlocks.builder(Material.field_151573_f)),
    CHAOS_IRON(CraftingItems.CHAOS_IRON_INGOT, MiscBlocks.builder(Material.field_151573_f)),
    CHAOS_GOLD(CraftingItems.CHAOS_GOLD_INGOT, MiscBlocks.builder(Material.field_151573_f)),
    CHAOS_SILVER(CraftingItems.CHAOS_SILVER_INGOT, MiscBlocks.builder(Material.field_151573_f));

    public static final ResourceLocation WALK_ON_ENDER_CRYSTAL;
    private final AbstractBlock.Properties builder;
    private BlockRegistryObject<MiscBlock> block;
    private final IItemProvider storedItem;

    private MiscBlocks(IItemProvider storedItem, AbstractBlock.Properties builder) {
        this.builder = builder;
        this.storedItem = storedItem;
    }

    private static AbstractBlock.Properties builder(Material material) {
        return AbstractBlock.Properties.func_200945_a((Material)material).func_200948_a(4.0f, 30.0f).func_200947_a(SoundType.field_185852_e);
    }

    public static void registerBlocks() {
        for (MiscBlocks block : MiscBlocks.values()) {
            block.block = new BlockRegistryObject(Registration.BLOCKS.register(block.getName(), () -> new MiscBlock(block, block.builder)));
            Registration.ITEMS.register(block.getName(), () -> new MiscBlockItem(block, new Item.Properties().func_200916_a(GemsItemGroups.BLOCKS)));
        }
    }

    public MiscBlock asBlock() {
        return (MiscBlock)this.block.get();
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT) + "_block";
    }

    public IItemProvider getStoredItem() {
        return this.storedItem;
    }

    static {
        WALK_ON_ENDER_CRYSTAL = SilentGems.getId("walk_on_ender_crystal");
    }

    static final class MiscBlockItem
    extends BlockItem {
        private final MiscBlocks type;

        MiscBlockItem(MiscBlocks type, Item.Properties builder) {
            super((Block)type.block.get(), builder);
            this.type = type;
        }

        public int getBurnTime(ItemStack itemStack) {
            return this.type == CHAOS_COAL ? 64000 : 0;
        }
    }

    static final class MiscBlock
    extends Block {
        private final MiscBlocks type;

        MiscBlock(MiscBlocks type, AbstractBlock.Properties properties) {
            super(properties);
            this.type = type;
        }

        public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
            if (this.type == ENDER_CRYSTAL && entityIn instanceof LivingEntity && worldIn.func_180495_p(pos).func_177230_c() == this) {
                int stackedBlocks = this.getStackedBlocks((IBlockReader)worldIn, pos);
                EffectInstance effect = new EffectInstance(Effects.field_188424_y, 100, stackedBlocks - 1);
                LivingEntity entityLiving = (LivingEntity)entityIn;
                entityLiving.func_195064_c(effect);
                if (entityIn instanceof ServerPlayerEntity) {
                    LibTriggers.GENERIC_INT.trigger((ServerPlayerEntity)entityIn, WALK_ON_ENDER_CRYSTAL, stackedBlocks);
                }
            }
        }

        private int getStackedBlocks(IBlockReader world, BlockPos pos) {
            int result = 1;
            BlockState state = world.func_180495_p(pos.func_177977_b());
            while (state.func_177230_c() == this && result < 5) {
                state = world.func_180495_p(pos.func_177979_c(++result));
            }
            return result;
        }
    }
}

