/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.purifier;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.silentchaos512.gems.block.purifier.PurifierContainer;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.init.GemsTileEntities;
import net.silentchaos512.gems.util.TextUtil;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;

public class PurifierTileEntity
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity {
    private static final int CHAOS_PER_POWDER = 100000;
    private static final int TICKS_PER_POWDER = 1000;
    private static final int CHAOS_PER_TICK = 100;
    private int burnTime;
    private int totalBurnTime;
    private final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return PurifierTileEntity.this.burnTime;
                }
                case 1: {
                    return PurifierTileEntity.this.totalBurnTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    PurifierTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    PurifierTileEntity.this.totalBurnTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public PurifierTileEntity() {
        super((TileEntityType)GemsTileEntities.PURIFIER.get(), 1);
    }

    public static boolean isPurifyingCatalyst(ItemStack stack) {
        return stack.func_77973_b() == GemsItems.PURIFYING_POWDER.get();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (Chaos.getChaos((ICapabilityProvider)this.field_145850_b) > Chaos.getEquilibriumPoint(this.field_145850_b) + 100) {
            if (this.burnTime > 0) {
                --this.burnTime;
                Chaos.dissipate(this.field_145850_b, 100);
            } else {
                ItemStack stack = this.func_70301_a(0);
                if (PurifierTileEntity.isPurifyingCatalyst(stack)) {
                    this.totalBurnTime = 1000;
                    this.burnTime = 1000;
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        this.func_70299_a(0, ItemStack.field_190927_a);
                    }
                }
            }
        }
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return itemStackIn.func_77973_b() == GemsItems.PURIFYING_POWDER.get();
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "purifier", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new PurifierContainer(id, player, this, this.fields);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        this.burnTime = tags.func_74762_e("BurnTime");
        this.totalBurnTime = tags.func_74762_e("TotalBurnTime");
        super.func_230337_a_(state, tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags.func_74768_a("BurnTime", this.burnTime);
        tags.func_74768_a("TotalBurnTime", this.totalBurnTime);
        return super.func_189515_b(tags);
    }
}

