/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.teleporter;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.block.teleporter.GemTeleporterBlock;
import net.silentchaos512.gems.block.teleporter.GemTeleporterTileEntity;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.lib.Gems;

public class RedstoneGemTeleporterBlock
extends GemTeleporterBlock {
    public RedstoneGemTeleporterBlock(Gems gem) {
        super(gem);
    }

    @Override
    public IFormattableTextComponent func_235333_g_() {
        if (this.gem == null) {
            return super.func_235333_g_();
        }
        return new TranslationTextComponent("block.silentgems.redstone_teleporter", new Object[]{this.gem.getDisplayName()});
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        GemTeleporterTileEntity tile = (GemTeleporterTileEntity)world.func_175625_s(pos);
        if (tile == null || tile.getDestination() == null) {
            return;
        }
        if (!world.field_72995_K && world.func_175687_A(pos) != 0) {
            int searchRadius = (Integer)GemsConfig.Common.teleporterSearchRadius.get();
            boolean playSound = false;
            for (Entity entity : world.func_217357_a(Entity.class, new AxisAlignedBB(pos).func_186662_g((double)searchRadius))) {
                if (!tile.tryTeleport(entity, false)) continue;
                playSound = true;
            }
            if (playSound) {
                tile.playSound();
            }
        }
    }
}

