/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.chaos;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gems.api.chaos.IChaosSource;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.chaos.ChaosEvents;
import net.silentchaos512.gems.chaos.ChaosSourceCapability;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="silentgems")
public final class ChaosHandler {
    private static final Marker MARKER = MarkerManager.getMarker((String)"ChaosHandler");

    private ChaosHandler() {
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (ChaosSourceCapability.canAttachTo((ICapabilityProvider)entity)) {
            event.addCapability(ChaosSourceCapability.NAME, (ICapabilityProvider)new ChaosSourceCapability());
        }
    }

    @SubscribeEvent
    public static void onAttachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        World world = (World)event.getObject();
        if (ChaosSourceCapability.canAttachTo((ICapabilityProvider)world)) {
            event.addCapability(ChaosSourceCapability.NAME, (ICapabilityProvider)new ChaosSourceCapability());
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (world.func_82737_E() % 20L == 0L) {
            entity.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> ChaosHandler.entitySourceTick((Entity)entity, world, source));
        }
    }

    private static void entitySourceTick(Entity entity, World world, IChaosSource source) {
        world.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(worldSource -> {
            int amount = Math.min(source.getChaos(), 50);
            worldSource.addChaos(amount);
            source.addChaos(-amount);
        });
        if (world.func_82737_E() % 20L == 0L && entity instanceof PlayerEntity) {
            int chaos = ChaosHandler.getEffectiveChaosForEvents(source, world);
            ChaosEvents.tryChaosEvents((PlayerEntity)entity, world, chaos);
        }
    }

    private static int getEffectiveChaosForEvents(IChaosSource player, World world) {
        IChaosSource worldSource = (IChaosSource)world.getCapability(ChaosSourceCapability.INSTANCE).orElseThrow(IllegalStateException::new);
        int equilibriumPoint = Chaos.getEquilibriumPoint(world);
        return ChaosHandler.getEffectiveChaosForEvents(player.getChaos(), worldSource.getChaos(), equilibriumPoint);
    }

    public static int getEffectiveChaosForEvents(int playerChaos, int worldChaos, int equilibrium) {
        if (playerChaos < 50000 && worldChaos > 2 * equilibrium) {
            return playerChaos + equilibrium;
        }
        return playerChaos + worldChaos;
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        if (world.func_82737_E() % 20L == 0L) {
            int equilibrium = Chaos.getEquilibriumPoint(world);
            int rate = Chaos.getDissipationRate(world);
            world.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> source.addChaos(source.getChaos() > equilibrium ? -rate : rate));
        }
    }
}

