/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.gear;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.gear.api.event.GetMaterialStatsEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.GemsEnchantments;

public class SGearStatHandler {
    public static final ItemStat CHARGEABILITY = new ItemStat(1.0f, 0.0f, 100.0f, TextFormatting.GOLD, new ItemStat.Properties().hidden());
    private static final Map<ItemStat, ToDoubleFunction<ChargedProperties>> BOOSTED_STATS = ImmutableMap.builder().put((Object)ItemStats.DURABILITY, prop -> (double)((ChargedProperties)prop).originalStat * Math.pow(2.0, ((ChargedProperties)prop).chargeValue)).put((Object)ItemStats.ARMOR_DURABILITY, prop -> (double)((ChargedProperties)prop).originalStat * Math.pow(1.8, ((ChargedProperties)prop).chargeValue)).put((Object)ItemStats.ENCHANTABILITY, prop -> (double)((ChargedProperties)prop).originalStat * (1.0 + (double)((ChargedProperties)prop).superchargedLevel * (Math.sqrt(((ChargedProperties)prop).chargeability) - 1.0))).put((Object)ItemStats.RARITY, prop -> ((ChargedProperties)prop).originalStat + (float)(((ChargedProperties)prop).superchargedLevel * 10)).put((Object)ItemStats.HARVEST_LEVEL, prop -> ((ChargedProperties)prop).originalStat + (float)((ChargedProperties)prop).superchargedLevel).put((Object)ItemStats.HARVEST_SPEED, prop -> ((ChargedProperties)prop).originalStat + (float)((ChargedProperties)prop).superchargedLevel * ((ChargedProperties)prop).chargeValue * 2.0f).put((Object)ItemStats.MELEE_DAMAGE, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue * 2.0f).put((Object)ItemStats.MAGIC_DAMAGE, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue * 2.0f).put((Object)ItemStats.RANGED_DAMAGE, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue).put((Object)ItemStats.ARMOR, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue).put((Object)ItemStats.ARMOR_TOUGHNESS, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue / 2.0f).put((Object)ItemStats.MAGIC_ARMOR, prop -> ((ChargedProperties)prop).originalStat + ((ChargedProperties)prop).chargeValue).build();
    private static final Set<StatInstance.Operation> SUPPORTED_OPS = Collections.unmodifiableSet(EnumSet.of(StatInstance.Operation.AVG, StatInstance.Operation.MAX, StatInstance.Operation.ADD));

    public static void registerStats(RegistryEvent.Register<ItemStat> event) {
        event.getRegistry().register(CHARGEABILITY.setRegistryName(SilentGems.getId("chargeability")));
    }

    @SubscribeEvent
    public void onGetMaterialStats(GetMaterialStatsEvent event) {
        ItemStack stack = event.getMaterial().getItem();
        int supercharged = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)GemsEnchantments.SUPERCHARGED.get()), (ItemStack)stack);
        if (supercharged > 0 && BOOSTED_STATS.containsKey(event.getStat())) {
            StatGearKey key = StatGearKey.of((IItemStat)CHARGEABILITY, (GearType)GearType.ALL);
            float chargeability = CHARGEABILITY.compute(0.0f, event.getMaterial().getStatModifiers(event.getPartType(), key));
            if (chargeability == 0.0f) {
                chargeability = 1.0f;
            }
            float chargeLevel = chargeability * (float)supercharged;
            for (int i = 0; i < event.getModifiers().size(); ++i) {
                StatInstance instance = (StatInstance)event.getModifiers().get(i);
                if (!SGearStatHandler.isSupportedOp(instance)) continue;
                ChargedProperties chargedProperties = new ChargedProperties(supercharged, chargeLevel, instance.getValue());
                float statValue = (float)BOOSTED_STATS.get(event.getStat()).applyAsDouble(chargedProperties);
                StatInstance replacement = instance.copySetValue(statValue);
                event.getModifiers().remove(i);
                event.getModifiers().add(i, replacement);
            }
        }
    }

    private static boolean isSupportedOp(StatInstance instance) {
        return SUPPORTED_OPS.contains(instance.getOp());
    }

    private static final class ChargedProperties {
        private final int superchargedLevel;
        private final float chargeValue;
        private final float chargeability;
        private final float originalStat;

        private ChargedProperties(int superchargedLevel, float chargeValue, float originalStat) {
            this.superchargedLevel = superchargedLevel;
            this.chargeValue = chargeValue;
            this.chargeability = this.chargeValue / (float)this.superchargedLevel;
            this.originalStat = originalStat;
        }
    }
}

