/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.jei;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.altar.AltarScreen;
import net.silentchaos512.gems.block.supercharger.SuperchargerPillarStructure;
import net.silentchaos512.gems.block.supercharger.SuperchargerScreen;
import net.silentchaos512.gems.block.tokenenchanter.TokenEnchanterScreen;
import net.silentchaos512.gems.compat.gear.SGearProxy;
import net.silentchaos512.gems.compat.jei.PurifierRecipeCategoryJei;
import net.silentchaos512.gems.compat.jei.SuperchargerPillarCategory;
import net.silentchaos512.gems.compat.jei.SuperchargingRecipeCategoryJei;
import net.silentchaos512.gems.compat.jei.TokenEnchanterRecipeCategoryJei;
import net.silentchaos512.gems.compat.jei.TransmutationAltarRecipeCategoryJei;
import net.silentchaos512.gems.crafting.recipe.AltarTransmutationRecipe;
import net.silentchaos512.gems.crafting.recipe.TokenEnchanterRecipe;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.gems.init.GemsTags;
import net.silentchaos512.gems.item.ChaosRuneItem;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.gems.item.EnchantmentTokenItem;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.lib.chaosbuff.IChaosBuff;
import net.silentchaos512.gems.lib.soul.Soul;

@JeiPlugin
public class SilentGemsPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = SilentGems.getId("plugin/main");
    static final ResourceLocation ALTAR_TRANSMUTATION = SilentGems.getId("category/altar_transmutation");
    static final ResourceLocation PURIFIER = SilentGems.getId("category/purifier");
    static final ResourceLocation SUPERCHARGER_PILLAR = SilentGems.getId("category/supercharger_pillar");
    static final ResourceLocation SUPERCHARGING = SilentGems.getId("category/supercharging");
    static final ResourceLocation TOKEN_ENCHANTING = SilentGems.getId("category/token_enchanting");
    static final ResourceLocation GUI_TEXTURE = SilentGems.getId("textures/gui/recipe_display.png");
    private static boolean initFailed = true;

    public static boolean hasInitFailed() {
        return initFailed;
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        initFailed = true;
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new PurifierRecipeCategoryJei(guiHelper), new TokenEnchanterRecipeCategoryJei(guiHelper), new TransmutationAltarRecipeCategoryJei(guiHelper)});
        if (SGearProxy.isLoaded()) {
            reg.addRecipeCategories(new IRecipeCategory[]{new SuperchargerPillarCategory(guiHelper), new SuperchargingRecipeCategoryJei(guiHelper)});
        }
        initFailed = false;
    }

    public void registerRecipes(IRecipeRegistration reg) {
        initFailed = true;
        reg.addRecipes(SilentGemsPlugin.getRecipesOfType(TokenEnchanterRecipe.RECIPE_TYPE), TOKEN_ENCHANTING);
        reg.addRecipes(SilentGemsPlugin.getRecipesOfType(AltarTransmutationRecipe.RECIPE_TYPE), ALTAR_TRANSMUTATION);
        reg.addRecipes(Collections.singletonList(new PurifierRecipeCategoryJei.Recipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{GemsItems.PURIFYING_POWDER}))), PURIFIER);
        if (SGearProxy.isLoaded()) {
            reg.addRecipes((Collection)ImmutableList.of((Object)new SuperchargerPillarStructure(1, (Collection<ITag<Item>>)ImmutableList.of(GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL1, GemsTags.Items.SUPERCHARGER_PILLAR_CAP)), (Object)new SuperchargerPillarStructure(2, (Collection<ITag<Item>>)ImmutableList.of(GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL2, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL1, GemsTags.Items.SUPERCHARGER_PILLAR_CAP)), (Object)new SuperchargerPillarStructure(3, (Collection<ITag<Item>>)ImmutableList.of(GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL3, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL3, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL2, GemsTags.Items.SUPERCHARGER_PILLAR_LEVEL1, GemsTags.Items.SUPERCHARGER_PILLAR_CAP))), SUPERCHARGER_PILLAR);
            IntStream.rangeClosed(1, 3).forEach(tier -> reg.addRecipes((Collection)MaterialManager.getValues().stream().filter(mat -> mat.isVisible(PartType.MAIN)).map(mat -> new SuperchargingRecipeCategoryJei.Recipe((IMaterial)mat, tier)).collect(Collectors.toList()), SUPERCHARGING));
        }
        SilentGemsPlugin.addInfoPage(reg, CraftingItems.ENDER_SLIME_BALL);
        SilentGemsPlugin.addInfoPage(reg, "glowrose", Arrays.stream(Gems.values()).map(gem -> new ItemStack((IItemProvider)gem.getGlowrose())));
        SilentGemsPlugin.addInfoPage(reg, GemsBlocks.LUMINOUS_FLOWER_POT);
        reg.addRecipes((Collection)Arrays.stream(Gems.values()).map(gem -> new ShapedRecipe(SilentGems.getId("rune_example_" + gem.getName()), "", 2, 1, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{gem.getChaosGem()}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{GemsItems.CHAOS_RUNE})}), new ItemStack((IItemProvider)gem.getChaosGem()))).collect(Collectors.toList()), VanillaRecipeCategoryUid.CRAFTING);
        initFailed = false;
    }

    private static List<IRecipe<?>> getRecipesOfType(IRecipeType<?> recipeType) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == recipeType).collect(Collectors.toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst((Object)new ItemStack(GemsBlocks.SUPERCHARGER), new ResourceLocation[]{SUPERCHARGING, SUPERCHARGER_PILLAR});
        reg.addRecipeCatalyst((Object)new ItemStack(GemsBlocks.TOKEN_ENCHANTER), new ResourceLocation[]{TOKEN_ENCHANTING});
        reg.addRecipeCatalyst((Object)new ItemStack(GemsBlocks.TRANSMUTATION_ALTAR), new ResourceLocation[]{ALTAR_TRANSMUTATION});
        reg.addRecipeCatalyst((Object)new ItemStack(GemsBlocks.PURIFIER), new ResourceLocation[]{PURIFIER});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(SuperchargerScreen.class, 79, 32, 24, 23, new ResourceLocation[]{SUPERCHARGING, SUPERCHARGER_PILLAR});
        reg.addRecipeClickArea(TokenEnchanterScreen.class, 102, 32, 24, 23, new ResourceLocation[]{TOKEN_ENCHANTING});
        reg.addRecipeClickArea(AltarScreen.class, 80, 32, 24, 23, new ResourceLocation[]{ALTAR_TRANSMUTATION});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        initFailed = true;
        reg.registerSubtypeInterpreter((Item)GemsItems.ENCHANTMENT_TOKEN.get(), stack -> {
            Enchantment enchantment = EnchantmentTokenItem.getSingleEnchantment(stack);
            return enchantment != null ? enchantment.func_77320_a() : "none";
        });
        reg.registerSubtypeInterpreter((Item)GemsItems.CHAOS_RUNE.get(), stack -> {
            IChaosBuff buff = ChaosRuneItem.getBuff(stack);
            return buff != null ? buff.getId().toString() : "";
        });
        reg.registerSubtypeInterpreter((Item)GemsItems.SOUL_GEM.get(), stack -> {
            Soul soul = SoulGemItem.getSoul(stack);
            return soul != null ? soul.getId().toString() : "";
        });
        initFailed = false;
    }

    private static void addInfoPage(IRecipeRegistration reg, IItemProvider item) {
        String key = SilentGemsPlugin.getDescKey(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
        ItemStack stack = new ItemStack(item);
        reg.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{key});
    }

    private static void addInfoPage(IRecipeRegistration reg, IItemProvider item, Stream<ItemStack> variants) {
        String key = SilentGemsPlugin.getDescKey(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), VanillaTypes.ITEM, new String[]{key});
    }

    private static void addInfoPage(IRecipeRegistration reg, String itemName, Stream<ItemStack> variants) {
        String key = SilentGemsPlugin.getDescKey(SilentGems.getId(itemName));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), VanillaTypes.ITEM, new String[]{key});
    }

    private static String getDescKey(ResourceLocation name) {
        return "jei." + name.func_110624_b() + "." + name.func_110623_a() + ".desc";
    }
}

