/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gems.api.chaos.ChaosEmissionRate;
import net.silentchaos512.gems.compat.jei.SilentGemsPlugin;
import net.silentchaos512.gems.crafting.recipe.AltarTransmutationRecipe;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.util.TextUtil;
import net.silentchaos512.lib.util.TextRenderUtils;

public class TransmutationAltarRecipeCategoryJei
implements IRecipeCategory<AltarTransmutationRecipe> {
    private static final int GUI_START_X = 0;
    private static final int GUI_START_Y = 117;
    private static final int GUI_WIDTH = 119;
    private static final int GUI_HEIGHT = 47;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public TransmutationAltarRecipeCategoryJei(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SilentGemsPlugin.GUI_TEXTURE, 0, 117, 119, 47);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(GemsBlocks.TRANSMUTATION_ALTAR));
        this.arrow = guiHelper.drawableBuilder(SilentGemsPlugin.GUI_TEXTURE, 73, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = I18n.func_135052_a((String)"category.silentgems.altar_transmutation", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return SilentGemsPlugin.ALTAR_TRANSMUTATION;
    }

    public Class<? extends AltarTransmutationRecipe> getRecipeClass() {
        return AltarTransmutationRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(AltarTransmutationRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        inputs.add(recipe.getIngredient());
        inputs.add(recipe.getCatalyst());
        ingredients.setInputIngredients(inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, AltarTransmutationRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 19, 0);
        itemStacks.init(1, true, 19, 20);
        itemStacks.init(2, false, 78, 10);
        itemStacks.set(0, Arrays.asList(recipe.getIngredient().func_193365_a()));
        itemStacks.set(1, Arrays.asList(recipe.getCatalyst().func_193365_a()));
        itemStacks.set(2, recipe.func_77571_b());
    }

    public void draw(AltarTransmutationRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 43, 11);
        Minecraft mc = Minecraft.func_71410_x();
        int chaos = recipe.getChaosGenerated();
        ChaosEmissionRate emissionRate = ChaosEmissionRate.fromAmount(chaos);
        ITextComponent str = emissionRate.getEmissionText(chaos);
        FontRenderer fontRenderer = mc.field_71466_p;
        IReorderingProcessor iReorderingProcessor = str.func_241878_f();
        mc.field_71466_p.getClass();
        TextRenderUtils.renderScaled((MatrixStack)matrixStack, (FontRenderer)fontRenderer, (IReorderingProcessor)iReorderingProcessor, (int)1, (int)(47 - 9 + 2), (float)0.8f, (int)-1, (boolean)true);
        ITextComponent catalystText = TextUtil.translate("jei", "recipe.altar.catalystNotConsumed", new Object[0]);
        FontRenderer fontRenderer2 = mc.field_71466_p;
        IReorderingProcessor iReorderingProcessor2 = catalystText.func_241878_f();
        mc.field_71466_p.getClass();
        TextRenderUtils.renderScaled((MatrixStack)matrixStack, (FontRenderer)fontRenderer2, (IReorderingProcessor)iReorderingProcessor2, (int)38, (int)(47 - 9 - 5), (float)0.5f, (int)-1, (boolean)true);
    }
}

